package com.wangxiaolu.promotion.service.activity.examine.impl;

import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.examine.dao.ActivityExamineDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-04-02 15
 * @describe :
 */
@Service
public class ExaPlanCoreServiceImpl implements ExaPlanCoreService {

    @Autowired
    private ActivityExamineDao activityExamineDao;
    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;

    @Override
    public ActivityExamineDto save(ActivityExamineDto examineDto) {
        // 根据促销计划id得到详情并补充
        ActivityPlanInfoDto planInfoDto = activityPlanInfoDao.selectById(examineDto.getPlanId());
        if (Objects.isNull(planInfoDto)) {
            throw new ParamException(RCode.ACTIVITY_PLAN_IS_NULL);
        }
        // 判断执行日期是否开始
        Date date = planInfoDto.getDate();
        if (date.after(new Date())) {
            throw new ParamException(RCode.ACTIVITY_NOT_START);
        }

        examineDto.setDeptQcOrgName(planInfoDto.getOrgName());
        examineDto.setManageName(planInfoDto.getEmployeeName());
        examineDto.setCity(planInfoDto.getCity());
        examineDto.setPlanDate(planInfoDto.getDate());
        examineDto.setLineName(planInfoDto.getLineName());
        examineDto.setStoreName(planInfoDto.getStoreName());
        examineDto.setDealerName(planInfoDto.getDealerName());
        examineDto.setPattern(planInfoDto.getPattern());
        return activityExamineDao.save(examineDto);
    }

    @Override
    public ActivityExamineDto updateById(ActivityExamineDto examineDto) {
        return activityExamineDao.updateById(examineDto);
    }
}
