package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.UserInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.UserInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.UserInfoDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-03-28 19
 * @describe :
 */
@Service
public class UserInfoDaoImpl implements UserInfoDao {

    @Autowired
    UserInfoMapper userInfoMapper;


    @Override
    public Integer findUserByUserName(String name) {
        LambdaQueryWrapper queryWrapper = buildQueryList(name);
        Integer cout = userInfoMapper.selectCount(queryWrapper);
        return cout;
    }

    private LambdaQueryWrapper buildQueryList(String name){
        LambdaQueryWrapper<UserInfoDO> queryWrapper = new LambdaQueryWrapper<>();
        if (!StringUtils.isEmpty(name)){
            queryWrapper.eq(UserInfoDO::getName,name);
        }
        return queryWrapper;
    }
}
