package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.util.MD5Utils;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.domain.activity.mapper.ManageEmployeeInfoMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.ManageEmployeeInfoDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
public class ManageEmployeeInfoInfoDaoImpl implements ManageEmployeeInfoDao {

    @Autowired
    ManageEmployeeInfoMapper manageEmployeeInfoMapper;

    @Override
    public ManageEmployeeInfoDto loginByEmployeeNo(String employeeNo, String pwd) {
        ManageEmployeeInfoDO manageEmployeeInfoDO = manageEmployeeInfoMapper.selectToLogin(employeeNo);

        if (Objects.isNull(manageEmployeeInfoDO)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
        if (!MD5Utils.getSaltverifyMD5(pwd, manageEmployeeInfoDO.getPasswork())){
            throw new ParamException(RCode.LOGIN_PASSWORD_ERROR,null);
        }

        return transitionDto(manageEmployeeInfoDO);
    }

    @Override
    public ManageEmployeeInfoDto selectById(Integer employeeId) {
        return transitionDto(manageEmployeeInfoMapper.selectById(employeeId));
    }

    @Override
    public ManageEmployeeInfoDto selectOne(ManageEmployeeWrapper ewrap) {
        LambdaQueryWrapper<ManageEmployeeInfoDO> qw = builderOneWrapper(ewrap);
        if (qw.isEmptyOfWhere()){
            return null;
        }
        return transitionDto(manageEmployeeInfoMapper.selectOne(qw));
    }

    @Override
    public List<ManageEmployeeInfoDto> selectList(ManageEmployeeWrapper ewrap) {
        LambdaQueryWrapper<ManageEmployeeInfoDO> qw = builderWrapper(ewrap);
        List<ManageEmployeeInfoDO> dos = manageEmployeeInfoMapper.selectList(qw);
        return transitionDtos(dos);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void openAccount(String employeeNo, Integer privilegeId) {
        ManageEmployeeInfoDO eDo = new ManageEmployeeInfoDO();
        eDo.setEmployeeNo(employeeNo);
        manageEmployeeInfoMapper.insertOne(eDo);
        addPrivilege(eDo.getId(),privilegeId);
    }

    @Override
    public boolean hasByEmpNo(String employeeNo) {
        Integer id = manageEmployeeInfoMapper.hasByEmpNo(employeeNo);
        return Objects.nonNull(id);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateAccount(String employeeNo, Integer privilegeId, String status) {
        manageEmployeeInfoMapper.updateByEmployeeNo(employeeNo,status);
        updatePrivilege(employeeNo,privilegeId);
    }

    @Override
    public boolean isOneSelf(Integer employeeId) {
        return manageEmployeeInfoMapper.isOneSelf(employeeId);
    }

    @Override
    public boolean isAuth(Integer employeeId) {
        return manageEmployeeInfoMapper.isAuth(employeeId);
    }

    /**
     * 增加权限
     */
    private void addPrivilege(Integer empId, Integer privilegeId) {
        manageEmployeeInfoMapper.addPrivilege(empId,privilegeId);
    }

    /**
     * 修改权限
     */
    private void updatePrivilege(String employeeNo, Integer privilegeId) {
        manageEmployeeInfoMapper.updatePrivilege(employeeNo,privilegeId);
    }

    private LambdaQueryWrapper<ManageEmployeeInfoDO> builderOneWrapper(ManageEmployeeWrapper ewrap){
        LambdaQueryWrapper<ManageEmployeeInfoDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(ewrap.getId())){
            qw.eq(ManageEmployeeInfoDO::getId,ewrap.getId());
        }
        if (Objects.nonNull(ewrap.getQcId())){
            qw.eq(ManageEmployeeInfoDO::getQcId,ewrap.getQcId());
        }
        if (Objects.nonNull(ewrap.getEmployeeNo())){
            qw.eq(ManageEmployeeInfoDO::getEmployeeNo,ewrap.getEmployeeNo());
        }
        qw.eq(ManageEmployeeInfoDO::getStatus,"0");
        return qw;
    }

    private LambdaQueryWrapper<ManageEmployeeInfoDO> builderWrapper(ManageEmployeeWrapper ewrap){
        LambdaQueryWrapper<ManageEmployeeInfoDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(ewrap.getId())){
            qw.eq(ManageEmployeeInfoDO::getId,ewrap.getId());
        }
        if (ewrap.isHasDeptQcId()){
            qw.ne(ManageEmployeeInfoDO::getDeptQcId,"");
        }
        if (!CollectionUtils.isEmpty(ewrap.getEmployeeNos())){
            qw.in(ManageEmployeeInfoDO::getEmployeeNo,ewrap.getEmployeeNos());
        }
        qw.eq(ManageEmployeeInfoDO::getStatus,"0");
        return qw;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param dos DO对象List
     * @return DTO对象
     */
    private List<ManageEmployeeInfoDto> transitionDtos(List<ManageEmployeeInfoDO> dos) {
        if (CollectionUtils.isEmpty(dos)) {
            return new ArrayList<>();
        }

        List<ManageEmployeeInfoDto> dtos = new ArrayList<>(dos.size() * 2);
        for (ManageEmployeeInfoDO edo : dos) {
            dtos.add(transitionDto(edo));
        }
        return dtos;
    }

    private ManageEmployeeInfoDto transitionDto(ManageEmployeeInfoDO employeeDO) {
        ManageEmployeeInfoDto dto = null;
        if (Objects.isNull(employeeDO)) {
            return dto;
        }
        dto = new ManageEmployeeInfoDto();
        BeanUtils.copyProperties(employeeDO, dto);
        return dto;
    }


}
