package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinceProductTypeDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceProductTypeMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinceProductTypeDO;
import com.wangxiaolu.promotion.pojo.user.dto.QinceProductTypeDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-19 15
 * @describe :
 */
@Slf4j
@Service
public class QinceProductTypeDaoImpl implements QinceProductTypeDao {

    @Autowired
    QinceProductTypeMapper qinceProductTypeMapper;

    @Override
    public void productPdTypeSyncTask(JSONArray responseDatas) {
        log.info("勤策-同步商品类型数据，共「{}」条数据", responseDatas.size());
        LambdaQueryWrapper<QinceProductTypeDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            // 查询人员是否存在
            QinceProductTypeDO qcDo = JSONObject.parseObject(JSONObject.toJSONString(responseData), QinceProductTypeDO.class);
            qw.eq(QinceProductTypeDO::getPrdWaiqin365Id, qcDo.getPrdWaiqin365Id());
            QinceProductTypeDO doExist = qinceProductTypeMapper.selectOne(qw);

            // 存在则修改，不存在则添加
            if (Objects.isNull(doExist)) {
                qinceProductTypeMapper.insert(qcDo);
                log.info("勤策-[{}]商品类型不存在，已添加，qc_id：{}", qcDo.getName(), qcDo.getPrdWaiqin365Id());
            } else {
                qcDo.setId(doExist.getId());
                qinceProductTypeMapper.updateById(qcDo);
                log.info("勤策--[{}]商品类型已存在，现已修改，qc_id：{}", qcDo.getName(), qcDo.getPrdWaiqin365Id());
            }

        }

    }

    @Override
    public List<QinceProductTypeDto> findAll() {
        LambdaQueryWrapper<QinceProductTypeDO> qw = new LambdaQueryWrapper<>();
        qw.eq(QinceProductTypeDO::getStatus,1).select(QinceProductTypeDO::getPrdWaiqin365Id,QinceProductTypeDO::getName);

        List<QinceProductTypeDO> qinceProductTypeDOS = qinceProductTypeMapper.selectList(qw);
        return transitionDtos(qinceProductTypeDOS);
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param productTypeDos DO对象List
     * @return DTO对象
     */
    private List<QinceProductTypeDto> transitionDtos(List<QinceProductTypeDO> productTypeDos) {
        if (CollectionUtils.isEmpty(productTypeDos)) {
            return new ArrayList<>();
        }

        List<QinceProductTypeDto> dtos = new ArrayList<>(productTypeDos.size() * 2);
        for (QinceProductTypeDO productTypeDo : productTypeDos) {
            dtos.add(transitionDto(productTypeDo));
        }
        return dtos;
    }

    private QinceProductTypeDto transitionDto(QinceProductTypeDO productTypeDo) {
        QinceProductTypeDto dto = null;
        if (Objects.isNull(productTypeDo)) {
            return dto;
        }
        dto = new QinceProductTypeDto();
        BeanUtils.copyProperties(productTypeDo, dto);
        return dto;
    }

}
