package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 *
 * @TableName temporary_activity_clock
 */
@Data
@Builder
public class TemporaryActivityTaskClockReq {

    /**
     * 主键id
     */
    private Long id;
    /**
     * 活动打卡id
     */
    @NotNull(message = "活动打卡id不能为空")
    private Long clockId;

    @NotNull(message = "促销员id不能为空")
    private Integer temporaryId;

    /**
     * temporary_info表name
     */
    @NotNull(message = "促销员名称不能为空")
    private String temporaryName;

    /**
     * 关联活动上报id
     */
    private Long reportedId;
    /**
     * 任务类型 和图片的工业
     * 10、随机任务 9、pos上传任务
     */
    @Min(value = 9, message = "任务类型只能是10、9")
    @Max(value = 10, message = "任务类型只能是10、9")
    private Integer taskType;

    /**
     * 任务状态
     * 1、待开始 2、进行中 3、未完成 4、已完成
     */
    @Size(min = 1, max = 4, message = "任务状态只能是1、2、3、4")
    private Integer taskStatus;

    /**
     * activity_plan_info表id
     */
    private Long planId;



    private List<String> clockPhotos;
}
