package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-23 19
 * @describe :
 */
@Slf4j
@Service
public class TemporaryActivityClockQueryServiceImpl implements TemporaryActivityClockQueryService {

    @Autowired
    private TemporaryActivityClockDao temporaryActivityClockDao;
    @Autowired
    private TemporaryActivityPhotoDao temporaryActivityPhotoDao;
    @Autowired
    private TemporaryInfoDao temporaryInfoDao;

    @Override
    public TemporaryClockDto findTodayTemporaryClockByTemId(Long temporaryId) {
        String today = DateUtil.today();
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(today);
        TemporaryClockDto temporaryClockDto = temporaryActivityClockDao.selectOne(tcw);
        findClockPhoto(temporaryClockDto);
        return temporaryClockDto;
    }

    /**
     * 查询指定日期打卡信息
     */
    @Override
    public TemporaryClockDto findTemporaryClockByTemIdAndDate(Long temporaryId, String createDate) {
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(createDate);
        TemporaryClockDto temporaryClockDto = temporaryActivityClockDao.selectOne(tcw);
        findClockPhoto(temporaryClockDto);
        return temporaryClockDto;
    }

    @Override
    public TemporaryClockDto findById(Long id) {
        TemporaryClockWrapper tcw = new TemporaryClockWrapper().setId(id);
        TemporaryClockDto temporaryClockDto = temporaryActivityClockDao.selectOne(tcw);
        findClockPhoto(temporaryClockDto);
        return temporaryClockDto;
    }

    @Override
    public TemporaryClockDto selectOne(TemporaryClockWrapper tcw) {
        TemporaryClockDto temporaryClockDto = temporaryActivityClockDao.selectOne(tcw);
        findClockPhoto(temporaryClockDto);
        if (Objects.nonNull(temporaryClockDto)) {
            // 查询促销员手机号
            Long temporaryId = temporaryClockDto.getTemporaryId();
            WxTemporaryInfoDto wxTemporaryInfoDto = temporaryInfoDao.selectOneById(temporaryId);
            temporaryClockDto.setPhone(Objects.isNull(wxTemporaryInfoDto) ? null : wxTemporaryInfoDto.getPhone());
        }
        return temporaryClockDto;
    }

    @Override
    public TemporaryClockDto findLatestClockByTemporaryId( Long temporaryId) {
        return temporaryActivityClockDao.findLatestClockByTemporaryId(temporaryId);
    }

    /**
     * 查询打卡主信息
     * @param wr
     * @return
     */
    @Override
    public TemporaryClockDto findClockInfo(TemporaryClockWrapper wr) {
        TemporaryClockDto temporaryClockDto = temporaryActivityClockDao.findClockInfo(wr);
        return temporaryClockDto;
    }

    /**
     * 获取打卡信息
     *
     * @param reportedId
     * @param temporaryId
     * @return
     */
    @Override
    public TemporaryClockDto findCLockInfoByReportedId(Long reportedId, Long temporaryId) {
        return temporaryActivityClockDao.findCLockInfoByReportedId(reportedId, temporaryId);
    }

    /**
     * 查询打卡图片
     */
    private void findClockPhoto(TemporaryClockDto temporaryClockDto) {
        if (Objects.isNull(temporaryClockDto)) {
            return;
        }
        Map<Integer, TemporaryActivityPhotoDto> photoGroup = temporaryActivityPhotoDao.findClockPhotoGroupByClockId(temporaryClockDto.getId());

        // 上班打卡
        TemporaryActivityPhotoDto clockInPhotoDto = photoGroup.get(ActivityPhotoType.CLOCK_IN.getType());
        if (Objects.nonNull(clockInPhotoDto)){
            temporaryClockDto.setClockInPhoto(clockInPhotoDto.getPhotoUrl());
            temporaryClockDto.setClockInPhotoUpdateTime(clockInPhotoDto.getUpdateTime());
        }

        // 午休下班卡
        TemporaryActivityPhotoDto noonClockOutPhotoDto = photoGroup.get(ActivityPhotoType.NOON_CLOCK_OUT.getType());
        if (Objects.nonNull(noonClockOutPhotoDto)){
            temporaryClockDto.setNoonClockOutPhoto(noonClockOutPhotoDto.getPhotoUrl());
            temporaryClockDto.setNoonClockOutPhotoUpdateTime(noonClockOutPhotoDto.getUpdateTime());
        }

        // 午休上班卡
        TemporaryActivityPhotoDto noonClockInPhotoDto = photoGroup.get(ActivityPhotoType.NOON_CLOCK_IN.getType());
        if (Objects.nonNull(noonClockInPhotoDto)){
            temporaryClockDto.setNoonClockInPhoto(noonClockInPhotoDto.getPhotoUrl());
            temporaryClockDto.setNoonClockInPhotoUpdateTime(noonClockInPhotoDto.getUpdateTime());
        }

        // 下班卡
        TemporaryActivityPhotoDto clockOutPhotoDto = photoGroup.get(ActivityPhotoType.CLOCK_OUT.getType());
        if (Objects.nonNull(clockOutPhotoDto)){
            temporaryClockDto.setClockOutPhoto(clockOutPhotoDto.getPhotoUrl());
            temporaryClockDto.setClockOutPhotoUpdateTime(clockOutPhotoDto.getUpdateTime());
        }

    }
}
