package com.wangxiaolu.promotion.controller.wechat;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.pojo.user.vo.WxJsUserInfoVo;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import static org.junit.jupiter.api.Assertions.*;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :
 */
@SpringBootTest
@RunWith(SpringRunner.class)
class WeChatUserCoreControllerTest {

    @Autowired
    WeChatUserCoreController weChatUserCoreController;
    @Autowired
    WeChatUserQueryController weChatUserQueryController;

    @Test
    void enrollUserInfo() {
        WxJsUserInfoVo vo = new WxJsUserInfoVo()
                .setOpenId("openid111")
                .setAvatarUrl("头像Url")
                .setName("姓名")
                .setPhone("手机号")
                .setAvatarUrlFieldId("avatarUrlFieldId")
                .setIdenNumber("身份证号")
                .setIdenFrontPhotoUrl("身份证正面照")
                .setIdenFrontPhotoFieldId("身份证正面照Id")
                .setIdenReversePhotoUrl("身份证反面照")
                .setIdenReversePhotoFieldId("身份证反面照Id")
                .setPhoneCode("手机验证码")
                ;
        System.out.println(JSONObject.toJSONString(vo));
        weChatUserCoreController.enrollUserInfo(vo);
    }

    @Test
    void getOpenIdByWxcode() {

        Boolean openIdByWxcode = weChatUserQueryController.temporaryLoginByOpenId("111");
        System.out.println(openIdByWxcode);
    }
}