package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.TencentCoreService;
import com.wangxiaolu.promotion.utils.DataUtils;
import com.wangxiaolu.promotion.utils.TencentUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-15 15
 * @describe :
 */
@Slf4j
@Service
public class TencentCoreServiceImpl implements TencentCoreService {

    @Value("${tengxunyun.sms.overdue_long}")
    private long overdueLong;

    @Autowired
    TencentUtils tencentUtils;
    @Autowired
    RedisCache redisCache;

    @Override
    public void sendSmsPhoneVerCOde(String phone) {
        String redisKey = RedisKeys.UserKeys.PHONE_VER_CODE.getKey() + phone;
        // 判断是否已获取
        String verCodeOld = redisCache.get(redisKey);
        if (StringUtils.isNotBlank(verCodeOld)){
            throw new ParamException(RCode.TENCENT_SMS_REPETITION, null);
        }

        // 生成6位验证码
        String phoneVerCode = DataUtils.phoneVerCode();
        log.info("腾讯云短信，发送验证码:{}-{}", phone, phoneVerCode);
        redisCache.addToMinute(redisKey, phoneVerCode, overdueLong);

//        boolean succss = tencentUtils.sendSmsPhoneVerCOde(phone, phoneVerCode);
        boolean succss = true;
        if (!succss) {
            redisCache.removeKey(redisKey);
            log.info("腾讯云短信发送失败：删除验证码:{}-{}", phone, phoneVerCode);
        }
    }
}
