package com.wangxiaolu.promotion.controller.tengxunyun;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.TencentCoreService;
import com.wangxiaolu.promotion.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-04-15 11
 * @describe : 对接腾讯云接口
 * 如：腾讯云短信
 */
@Slf4j
@RestController
@RequestMapping("/tencent/core")
public class TencentCoreController {

    @Autowired
    TencentCoreService tencentCoreService;

    /**
     * 腾讯云短信
     */
    @PostMapping("/send/sms")
    public void sendSms(@RequestBody Map<String, String> phoneInfo) {
        String phone = phoneInfo.get("phone");
        if (StringUtils.isEmpty(phone) || !DataUtils.phonePattern(phone)) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        tencentCoreService.sendSmsPhoneVerCOde(phone);
    }


}
