package com.wangxiaolu.promotion.controller.user.qince;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.QinCeEmployeeDto;
import com.wangxiaolu.promotion.pojo.user.vo.QinceEmployeeQueryVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.user.QinCeEmployeeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-17 14
 * @describe : 勤策人员查询
 */
@RestController
@RequestMapping("/user/employee/query")
public class QinCeEmployeeQueryController {

    @Autowired
    QinCeEmployeeQueryService qinCeEmployeeQueryService;

    /**
     * 查询人员列表
     * 仅限注册时使用
     */
    @PostMapping("/enroll/list")
    public R getEmployeeList(@RequestBody QinceEmployeeQueryVo employeeQueryVo){
        List<QinCeEmployeeDto> employees = qinCeEmployeeQueryService.getEmployeeList(employeeQueryVo);
        return R.success(employees);
    }


}
