package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityPhotoMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityPhotoDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-05-09 11
 * @describe :
 */
@Slf4j
@Service
public class TemporaryActivityPhotoDaoImpl implements TemporaryActivityPhotoDao {

    @Autowired
    TemporaryActivityPhotoMapper temporaryActivityPhotoMapper;

    @Override
    public void saveReportedList(Integer temporaryId, Long reportedId, Integer photoType, List<String> urls, List<String> changeUrls) {
        if (CollectionUtils.isEmpty(changeUrls)) {
            log.info("活动id[{}]图片无改变值", reportedId);
            return;
        }

        Map<String, String> urlTypeMap = new HashMap<>();
        for (String changeUrl : changeUrls) {
            String[] uArr = changeUrl.split("/");
            String type = uArr[0];
            String uId = uArr[uArr.length - 1];
            urlTypeMap.put(uId, type);
        }
        log.info("活动id[{}]图片修改后的list为：{}", reportedId, urlTypeMap);


        for (String photoUrl : urls) {
            String[] photoArr = photoUrl.split("/");
            String photoFiledId = photoArr[photoArr.length - 1];
            String type = urlTypeMap.get(photoFiledId);

            log.info("图片文件id[{}]类型为{}", photoFiledId, type);
            // 现存图片列表中不存在，删除
            if (StringUtils.isBlank(type)) {
                temporaryActivityPhotoMapper.updateIsDelete(reportedId, photoFiledId);
            } else if ("cloud:".equals(type)) {
                // 新增数据
                TemporaryActivityPhotoDO photoDo = new TemporaryActivityPhotoDO();
                photoDo.setTemporaryId(temporaryId).setReportedId(reportedId).setType(photoType).setPhotoUrl(photoUrl).setPhotoFiledId(photoFiledId);
                temporaryActivityPhotoMapper.insert(photoDo);
            }
        }
    }

    /**
     * 保存促销员上下班打卡图片
     */
    @Override
    public void saveClockPhoto(Integer temporaryId, Long clockId, Integer photoType, String url) {
        saveClockPhoto(temporaryId, clockId, photoType, url, null);
    }


    @Override
    public void saveClockPhotoByUpdate(Integer temporaryId, Long id, Integer photoType, String url) {
        saveClockPhoto(temporaryId, id, photoType, url, true);
    }

    private void saveClockPhoto(Integer temporaryId, Long clockId, Integer photoType, String url, Boolean isUpdate) {
        String[] photoArr = url.split("/");
        String photoFiledId = photoArr[photoArr.length - 1];

        TemporaryActivityPhotoDO photoDo = new TemporaryActivityPhotoDO();
        photoDo.setTemporaryId(temporaryId).setClockId(clockId).setType(photoType).setPhotoUrl(url).setPhotoFiledId(photoFiledId);
        if (Objects.nonNull(isUpdate) && isUpdate) {
            photoDo.setUpdateTime(new Date());
        }

        temporaryActivityPhotoMapper.insert(photoDo);
        log.info("保存促销员打卡图片：{}", photoDo);
    }


    /**
     * 活动上报图片查询
     *
     * @param temporaryId 促销员id
     * @param reportedId  活动id
     */
    @Override
    public Map<Integer, List<String>> findReportedGroup(Integer temporaryId, Long reportedId) {
        LambdaQueryWrapper<TemporaryActivityPhotoDO> wq = new LambdaQueryWrapper<>();
        wq.eq(TemporaryActivityPhotoDO::getReportedId, reportedId).eq(TemporaryActivityPhotoDO::getIsDelete, 1);
        List<TemporaryActivityPhotoDO> dos = temporaryActivityPhotoMapper.selectList(wq);
        if (CollectionUtils.isEmpty(dos)) {
            return null;
        }
        Map<Integer, List<String>> groupPhoto = dos.stream().collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getType, Collectors.mapping(TemporaryActivityPhotoDO::getPhotoUrl, Collectors.toList())));
        return groupPhoto;
    }

    /**
     * 根据打卡ID查询图片，根据业务类型进行分组
     *
     * @param clockId 打卡ID
     * @return 分组结果
     */
    @Override
    public Map<Integer, TemporaryActivityPhotoDto> findClockPhotoGroupByClockId(Long clockId) {
        LambdaQueryWrapper<TemporaryActivityPhotoDO> wq = new LambdaQueryWrapper<>();
        wq.eq(TemporaryActivityPhotoDO::getClockId, clockId).eq(TemporaryActivityPhotoDO::getIsDelete, 1);
        List<TemporaryActivityPhotoDO> dos = temporaryActivityPhotoMapper.selectList(wq);
        List<TemporaryActivityPhotoDto> photoDtos = transitionDtos(dos);
        Map<Integer, TemporaryActivityPhotoDto> dtoMap = photoDtos.stream().collect(Collectors.toMap(TemporaryActivityPhotoDto::getType, pDto -> pDto));
//        Map<Integer, String> map = dos.stream().collect(Collectors.toMap(TemporaryActivityPhotoDO::getType, TemporaryActivityPhotoDO::getPhotoUrl));
        return dtoMap;
    }

    @Override
    public void updateStatus(TemporaryPhotoWrapper pw, int status) {
        LambdaQueryWrapper<TemporaryActivityPhotoDO> qw = builderWrapper(pw);
        if (qw.isEmptyOfWhere()) {
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }

        TemporaryActivityPhotoDO photoDO = new TemporaryActivityPhotoDO()
                .setIsDelete(status);
        temporaryActivityPhotoMapper.update(photoDO, qw);
    }

    private LambdaQueryWrapper<TemporaryActivityPhotoDO> builderWrapper(TemporaryPhotoWrapper pw) {
        LambdaQueryWrapper<TemporaryActivityPhotoDO> wq = new LambdaQueryWrapper<>();
        if (!Objects.isNull(pw.getClockId())) {
            wq.eq(TemporaryActivityPhotoDO::getClockId, pw.getClockId());
        }
        if (!Objects.isNull(pw.getType())) {
            wq.eq(TemporaryActivityPhotoDO::getType, pw.getType());
        }
        if (!Objects.isNull(pw.getTemporaryId()) && pw.getTemporaryId() > 0) {
            wq.eq(TemporaryActivityPhotoDO::getTemporaryId, pw.getTemporaryId());
        }
        return wq;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param photoDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryActivityPhotoDto> transitionDtos(List<TemporaryActivityPhotoDO> photoDos) {
        if (CollectionUtils.isEmpty(photoDos)) {
            return new ArrayList<>();
        }

        List<TemporaryActivityPhotoDto> dtos = new ArrayList<>(photoDos.size() * 2);
        for (TemporaryActivityPhotoDO photoDo : photoDos) {
            dtos.add(transitionDto(photoDo));
        }
        return dtos;
    }

    private TemporaryActivityPhotoDto transitionDto(TemporaryActivityPhotoDO photoDo) {
        TemporaryActivityPhotoDto dto = null;
        if (Objects.isNull(photoDo)) {
            return dto;
        }
        dto = new TemporaryActivityPhotoDto();
        BeanUtils.copyProperties(photoDo, dto);
        return dto;
    }
}
