package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.common.excel.ReadExcelUtils;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanRecordDao;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordCoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-08-21 13
 * @describe :
 */
@Service
public class ActivityPlanRecordCoreServiceImpl implements ActivityPlanRecordCoreService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EmployeeActivityPlanRecordDao employeeActivityPlanRecordDao;
    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveActivityPlan(EmployeeActivityPlanRecordDto planDto, ActivityPlanVo activityPlanVo) throws Exception {
        // 保存上传记录
        Long planRecordId = employeeActivityPlanRecordDao.save(planDto);
//        Long planRecordId = 37L;
        planDto.setId(planRecordId);
        // 解析excel表是否符合规范、保存
        saveActivityPlanInfo(activityPlanVo, planDto);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteById(Long id) {
        employeeActivityPlanRecordDao.deleteById(id);
        employeeActivityPlanInfoDao.deletebyActivityPlanRecordId(id);
    }

    private void saveActivityPlanInfo(ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 下载
        String filePath = "./activity_plan/" + activityPlanVo.getEmployeeNo() + "/" + planDto.getExcelFiledId();
        downloadExcel(activityPlanVo.getExcelUrl(),filePath);
        // 读取
        List<EmployeeActivityPlanInfoDto> planInfoDtos = readSheet0(filePath, activityPlanVo, planDto);
        // 保存
        employeeActivityPlanInfoDao.saveList(planInfoDtos);
    }

    private void downloadExcel( String urlStr,String filePath) throws Exception{
        // 保存文件
        URL url = new URL(urlStr);
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
        // 调大小
        byte[] buffer = new byte[102400];
        int bytesRead;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            fileOutputStream.write(buffer, 0, bytesRead);
        }
        fileOutputStream.close();
        inputStream.close();
    }

    private List<EmployeeActivityPlanInfoDto> readSheet0(String filePath, ActivityPlanVo activityPlanVo, EmployeeActivityPlanRecordDto planDto) throws Exception {
        // 1、解析表格数据
        ReadExcelUtils readExcelUtils = new ReadExcelUtils(filePath);
        Map<Integer, List<Object>> rows = readExcelUtils.readContent();
        if (rows.size() <= 0) {
            throw new DataException(RCode.API_DATA_ERROR);
        }

        Map<Object, Object> dealers = redisCache.getAllHash(RedisKeys.UserKeys.DEALER_HAVE_LIST.getKey());
        // 2、校验数据准确性
        verifyRow(rows,dealers);

        /**
         * 3、保存入库
         */
        List<EmployeeActivityPlanInfoDto> planInfoDtos = new ArrayList<>(rows.size() * 2);

        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            List<Object> value = entry.getValue();

            EmployeeActivityPlanInfoDto planInfoDto = new EmployeeActivityPlanInfoDto()
                    .setActivityPlanRecordId(planDto.getId())
                    .setExcelFiledId(planDto.getExcelFiledId())
                    .setEmployeeId(activityPlanVo.getEmployeeId())
                    .setEmployeeName(activityPlanVo.getEmployeeName())
                    .setEmployeeNo(activityPlanVo.getEmployeeNo())
                    .setActivityMonth(planDto.getActivityMonth())
                    .setCity((String) value.get(0))
                    .setDealerId((String) value.get(1))
                    .setDealerName((String) dealers.get(value.get(1)))
                    .setLineName((String) value.get(2))
                    .setStoreName((String) value.get(3))
                    .setActivityPattern((String) value.get(4))
                    .setActivityStartDate((Date) value.get(5))
                    .setActivityEndDate((Date) value.get(6))
                    .setHupiCount(Integer.parseInt(StringUtils.isBlank((String)value.get(7)) ? "0" : (String) value.get(7)))
                    .setQuguCount(Integer.parseInt(StringUtils.isBlank((String)value.get(8)) ? "0" : (String) value.get(8)))
                    .setTemporaryOnTime((String) value.get(9));

            planInfoDtos.add(planInfoDto);
        }
        return planInfoDtos;
    }

    /**
     * 校验数据是否规范
     */
    private void verifyRow(Map<Integer, List<Object>> rows, Map<Object, Object> dealers) throws Exception {
        for (Map.Entry<Integer, List<Object>> entry : rows.entrySet()) {
            Integer rowNo = entry.getKey()+1;
            List<Object> value = entry.getValue();
            System.out.println(value);

            String city = (String) value.get(0);
            if (StringUtils.isBlank(city)) {
                throw new DataException("第"+rowNo+"行 - 城市不可为空");
            }

            String dealerId = (String) value.get(1);
            if (!dealers.containsKey(dealerId.trim())) {
                throw new DataException("第"+rowNo+"行 - 经销商编码错误");
            }

            String lineName = (String) value.get(2);
            if (StringUtils.isBlank(lineName)) {
                throw new DataException("第"+rowNo+"行 - 系统名称为空");
            }

            String storeName = (String) value.get(3);
            if (StringUtils.isBlank(storeName)) {
                throw new DataException("第"+rowNo+"行 - 店铺名称为空");
            }

            String pattern = (String) value.get(4);
            if (StringUtils.isBlank(pattern)) {
                throw new DataException("第"+rowNo+"行 - 活动模式为空");
            }

            Object activityStartDateO = value.get(5);
            if (StringUtils.isBlank(activityStartDateO.toString()) || !(activityStartDateO instanceof Date)) {
                throw new DataException("第"+rowNo+"行 - 活动开始时间为空或格式错误（请将【开始日期】【结束日期】两列设置为时间格式）");
            }

            Object activityENDDateO = value.get(6);
            if (StringUtils.isBlank(activityENDDateO.toString()) || !(activityENDDateO instanceof Date)) {
                throw new DataException("第"+rowNo+"行 - 活动结束时间为空或格式错误（请将【开始日期】【结束日期】两列设置为时间格式）");
            }
        }
    }
}
