package com.wangxiaolu.promotion.controller.user.login.tem;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.DataUtils;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryLoginVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 13
 * @describe :微信用户信息查询
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/query")
public class temporaryInfoQueryController {

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;
    @Autowired
    RedisCache redisCache;

    /**
     * 根据OpenId、Phone登录（促销员查询是否存在）
     *
     * @return 非null则登录成功
     */
    @PostMapping("/temporary/login/phone_openid")
    public R temporaryLoginByPhoneAndOpenId(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        phontAndOpenIdVerify(wxTemporaryLoginVo);
        if (!DataUtils.phonePattern(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        LoginVo loginVo = weChatUserQueryService.loginTemporaryByOpenIdAndPhone(wxTemporaryLoginVo.getOpenId(), wxTemporaryLoginVo.getPhone());
        return R.success(loginVo);
    }


    /**
     * 促销员信息查询
     */
    @PostMapping("/temporary/phone_openid")
    public R getTemporaryInfoByOpenIdAndPhone(@RequestHeader("Authorization") String authorization, @RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        // 在缓存中查询
        JSONObject userJson = redisCache.getToJson(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey() + authorization);
        if (Objects.isNull(userJson)) {
            throw new ParamException(RCode.NOT_LOGIN_ERROR, null);
        }
        return R.success(userJson);
    }

    private void phontAndOpenIdVerify(WxTemporaryLoginVo wxTemporaryLoginVo) {
        if (StringUtils.isBlank(wxTemporaryLoginVo.getOpenId()) || StringUtils.isBlank(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, null);
        }
    }
}
