package com.wangxiaolu.promotion.domain.examine.dao.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.examine.dao.ActivityExamineDao;
import com.wangxiaolu.promotion.domain.examine.mapper.ActivityExamineMapper;
import com.wangxiaolu.promotion.domain.examine.mapper.entity.ActivityExamineDO;
import com.wangxiaolu.promotion.domain.examine.wrapperQo.ExamineWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-04-02 14
 * @describe :
 */
@Service
public class ActivityExamineDaoImpl implements ActivityExamineDao {

    @Autowired
    private ActivityExamineMapper activityExamineMapper;

    @Override
    public ActivityExamineDto selectById(Long id) {
        ActivityExamineDO activityExamineDO = activityExamineMapper.selectById(id);
        return returnDo(activityExamineDO);
    }

    @Override
    public ActivityExamineDto selectByPlanId(Long planId) {
        ActivityExamineDO examineDO = activityExamineMapper.selectByPlanId(planId);
        return returnDo(examineDO);
    }

    @Override
    public ActivityExamineDto save(ActivityExamineDto examineDto) {
        try {
            ActivityExamineDO examineDO = new ActivityExamineDO();
            BeanUtils.copyProperties(examineDto, examineDO);
            arrayToStringByDo(examineDO, examineDto);
            activityExamineMapper.insert(examineDO);
            ActivityExamineDO examineDO1 = activityExamineMapper.selectById(examineDO.getId());
            return returnDo(examineDO1);
        } catch (Exception e) {
            String eMsg = e.getCause().getMessage();
            if (eMsg.contains("for key 'plan_id_unique'")) {
                throw new ParamException(RCode.DATA_HAVE_ERROR);
            }
            return null;
        }
    }

    @Override
    public ActivityExamineDto updateById(ActivityExamineDto examineDto) {
        ActivityExamineDO examineDO = new ActivityExamineDO();
        BeanUtils.copyProperties(examineDto,examineDO);
        arrayToStringByDo(examineDO,examineDto);
        activityExamineMapper.updateById(examineDO);
        ActivityExamineDO examineDO1 = activityExamineMapper.selectById(examineDO.getId());
        return returnDo(examineDO1);
    }

    @Override
    public void page(PageInfo pageInfo, ExamineWrapper wq) {
        LambdaQueryWrapper<ActivityExamineDO> qw = buildWq(wq);
        Page<ActivityExamineDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<ActivityExamineDO> doPage = activityExamineMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(doPage.getRecords());
    }

    private LambdaQueryWrapper<ActivityExamineDO> buildWq(ExamineWrapper wq){
        LambdaQueryWrapper<ActivityExamineDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wq.getEmployeeId())){
            qw.eq(ActivityExamineDO::getEmployeeId,wq.getEmployeeId());
        }
        if (Objects.nonNull(wq.getCreateDate())){
            qw.eq(ActivityExamineDO::getCreateDate,wq.getCreateDate());
        }
        return qw;
    }


    private ActivityExamineDto returnDo(ActivityExamineDO activityExamineDO) {
        ActivityExamineDto dto = BeanUtils.transitionDto(activityExamineDO, ActivityExamineDto.class);
        if (Objects.isNull(dto)){
            return null;
        }
        dto.setTemWorkPhotos(Objects.isNull(activityExamineDO.getTemWorkPhotos()) ? null : JSONArray.parseArray(activityExamineDO.getTemWorkPhotos()));
        dto.setPosPhotos(Objects.isNull(activityExamineDO.getPosPhotos()) ? null : JSONArray.parseArray(activityExamineDO.getPosPhotos()));
        return dto;
    }

    private void arrayToStringByDo(ActivityExamineDO examineDO, ActivityExamineDto examineDto) {
        examineDO.setTemWorkPhotos(Objects.isNull(examineDto.getTemWorkPhotos()) ? null : JSONObject.toJSONString(examineDto.getTemWorkPhotos()));
        examineDO.setPosPhotos(Objects.isNull(examineDto.getPosPhotos()) ? null : JSONObject.toJSONString(examineDto.getPosPhotos()));
    }

}
