package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName temporary_activity_reported
 */
@TableName(value ="temporary_activity_reported")
@Data
public class TemporaryActivityReportedDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 关联—temporary_info表id
     */
    private Integer temporaryId;

    /**
     * 关联—temporary_info表name
     */
    private String temporaryName;

    /**
     * 关联—活动店铺id
     */
    private String storeQcId;

    private Long storeId;

    private String lineName;

    /**
     * 关联—活动店铺名称（例：小美超市）
     */
    private String storeName;

    /**
     * 关联—活动店铺地址（例：北京朝阳北路31号1层）
     */
    private String storeAddr;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 活动模式Id
     */
    Integer activityPatternId;

    /**
     * 活动模式
     */
    String activityPattern;

    private String deptQcId;

    private String deptQcOrgName;
    /**
     * 关联—审核人员qc_id
     */
    private String approverId;

    /**
     * 关联—审核人员姓名
     */
    private String approveName;

    /**
     * 审批状态（审批中、审批通过、退回……）
     * 关联enum类 TemActApproveStatus
     */
    private String approveStatus;

    /**
     * 最后一次审批时间
     */
    private Date approveTime;

    /**
     * 退回原因
     */
    private String approveReason;
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建日期
     */
    private String createDate;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 是否删除
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}