package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName qince_dealer
 */
@TableName(value ="qince_dealer")
@Data
public class QinceDealerDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 合作状态。0：终止合作，1：合作中，2：未合作，3：有意向
     */
    private String dealerCooperateStatus;

    /**
     * 经销商助理ID（多个用逗号隔开）
     */
    private String dealerAssistantId;

    /**
     * 经销商助理姓名（多个用逗号隔开）
     */
    private String dealerAssistantName;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}