package com.wangxiaolu.promotion.controller.wechat;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryEnrollVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import com.wangxiaolu.promotion.common.util.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-04-03 17
 * @describe : 微信用户信息
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/core")
public class WeChatUserCoreController {

    @Autowired
    WeChatUserCoreService weChatUserCoreService;
    @Autowired
    RedisCache redisCache;

    /**
     * 促销员注册信息
     */
    @PostMapping("/temporary/enroll")
    public R enrollUserInfo(@RequestBody @Validated WxTemporaryEnrollVo wxTemporaryEnrollVo) {
        log.info("微信-促销员注册：{}", JSONObject.toJSONString(wxTemporaryEnrollVo));
        // 人员信息校验
        boolean isIden = DataUtils.idenCardPattern(wxTemporaryEnrollVo.getIdenNumber());
        boolean isPhone = DataUtils.phonePattern(wxTemporaryEnrollVo.getPhone());
        if (!isIden || !isPhone) {
            throw new ParamException(RCode.ENROLL_PARAM_ERROR, null);
        }

        /**
         * 手机号-验证码 校验
         */
        String redisKey = RedisKeys.UserKeys.PHONE_VER_CODE.getKey() + wxTemporaryEnrollVo.getPhone();
        String phoneCodeOld = redisCache.get(redisKey);
        if (StringUtils.isBlank(phoneCodeOld) || !phoneCodeOld.equals(wxTemporaryEnrollVo.getPhoneCode())){
            throw new ParamException(RCode.TENCENT_SMS_PHONE_CODE_ERROR, null);
        }
        redisCache.removeKey(redisKey);

        WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
        BeanUtils.copyProperties(wxTemporaryEnrollVo, temporaryDto);
        return R.success(weChatUserCoreService.saveWxUserInfoTemporary(temporaryDto));
    }

}
