package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.activity.dao.PromotionManageEmployeeDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ManageEmployeeVo;
import com.wangxiaolu.promotion.pojo.user.dto.PromotionManageEmployeeDto;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-09-20 11
 * @describe :
 */
@Service
public class ManageEmployeeQueryServiceImpl implements ManageEmployeeQueryService {

    @Autowired
    PromotionManageEmployeeDao promotionManageEmployeeDao;

    @Override
    public PromotionManageEmployeeDto findOne(ManageEmployeeVo manageEmployeeVo) {
        ManageEmployeeWrapper ewrap = new ManageEmployeeWrapper();
        BeanUtils.copyProperties(manageEmployeeVo,ewrap);
        return promotionManageEmployeeDao.selectOne(ewrap);
    }

    @Override
    public List<PromotionManageEmployeeDto> findList(ManageEmployeeVo manageEmployeeVo) {
        ManageEmployeeWrapper wrap = new ManageEmployeeWrapper();
        BeanUtils.copyProperties(manageEmployeeVo,wrap);
        return promotionManageEmployeeDao.selectList(wrap);
    }
}
