package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeEmployeeDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceEmployeeMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinCeDepartmentDO;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinCeEmployeeDO;
import com.wangxiaolu.promotion.domain.user.wrapperQo.EmployeeWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.QinCeEmployeeDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeDepartmentDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-03-29 17
 * @describe :勤策人员数据处理
 */
@Slf4j
@Service
public class QinCeEmployeeDaoImpl implements QinCeEmployeeDao {

    @Autowired
    QinceEmployeeMapper qinceEmployeeMapper;

    @Override
    public void employeeSyncTask(JSONArray responseDatas) {
        log.info("勤策-同步人员数据，共「{}」条数据", responseDatas.size());
        LambdaQueryWrapper<QinCeEmployeeDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            // 查询人员是否存在
            QinCeEmployeeDO qcDo = JSONObject.parseObject(JSONObject.toJSONString(responseData), QinCeEmployeeDO.class);
            qw.eq(QinCeEmployeeDO::getQcId, qcDo.getQcId());
            QinCeEmployeeDO doExist = qinceEmployeeMapper.selectOne(qw);

            // 存在则修改，不存在则添加
            if (Objects.isNull(doExist)) {
                qinceEmployeeMapper.insert(qcDo);
                log.info("勤策-[{}]人员数据未存在，已添加，手机号：{}", qcDo.getEmpName(), qcDo.getEmpMobile());
            } else {
                qcDo.setId(doExist.getId());
                qinceEmployeeMapper.updateById(qcDo);
                log.info("勤策--[{}]人员数据已存在，现已修改，手机号：{}", qcDo.getEmpName(), qcDo.getEmpMobile());
            }

        }

    }

    @Override
    public QinCeEmployeeDto selectOntByQcId(String qcId) {
        LambdaQueryWrapper<QinCeEmployeeDO> qw = new LambdaQueryWrapper<>();
        qw.eq(QinCeEmployeeDO::getQcId, qcId);
        QinCeEmployeeDO qcEmpDo = qinceEmployeeMapper.selectOne(qw);
        return transitionDto(qcEmpDo);
    }

    @Override
    public List<QinCeEmployeeDto> getEmployeeList(EmployeeWrapper ew) {
        LambdaQueryWrapper<QinCeEmployeeDO> qw = buildWrapper(ew);
        List<QinCeEmployeeDO> qinCeEmployeeDOS = qinceEmployeeMapper.selectList(qw);
        return transitionDtos(qinCeEmployeeDOS);
    }

    private LambdaQueryWrapper<QinCeEmployeeDO> buildWrapper(EmployeeWrapper ew){
        LambdaQueryWrapper<QinCeEmployeeDO> qw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(ew.getWaiqin365OrgId())){
            qw.eq(QinCeEmployeeDO::getWaiqin365OrgId,ew.getWaiqin365OrgId());
        }
        if (StringUtils.isNotBlank(ew.getEmpName())){
            qw.like(QinCeEmployeeDO::getEmpName,ew.getEmpName());
        }
        qw.eq(QinCeEmployeeDO::getEmpStatus,1);
        qw.last("limit 50");
        return qw;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param employeeDOS DO对象List
     * @return DTO对象
     */
    private List<QinCeEmployeeDto> transitionDtos(List<QinCeEmployeeDO> employeeDOS) {
        if (CollectionUtils.isEmpty(employeeDOS)) {
            return new ArrayList<>();
        }

        List<QinCeEmployeeDto> dtos = new ArrayList<>(employeeDOS.size() * 2);
        for (QinCeEmployeeDO employe : employeeDOS) {
            dtos.add(transitionDto(employe));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param qcEmpDo DO对象
     * @return DTO对象
     */
    private QinCeEmployeeDto transitionDto(QinCeEmployeeDO qcEmpDo) {
        QinCeEmployeeDto qcEmpDto = null;
        if (!Objects.isNull(qcEmpDo)) {
            qcEmpDto = new QinCeEmployeeDto();
            BeanUtils.copyProperties(qcEmpDo, qcEmpDto);
        }
        return qcEmpDto;
    }
}
