package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.util.MD5Utils;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionManageEmployeeDao;
import com.wangxiaolu.promotion.domain.activity.mapper.PromotionManageEmployeeMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.PromotionManageEmployeeDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.ManageEmployeeWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.PromotionManageEmployeeDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
public class PromotionManageEmployeeDaoImpl implements PromotionManageEmployeeDao {

    @Autowired
    PromotionManageEmployeeMapper promotionManageEmployeeMapper;

    @Override
    public PromotionManageEmployeeDto loginByEmployeeNo(String employeeNo, String pwd) {
        PromotionManageEmployeeDO promotionManageEmployeeDO = promotionManageEmployeeMapper.selectToLogin(employeeNo);

        if (Objects.isNull(promotionManageEmployeeDO)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
        if (!MD5Utils.getSaltverifyMD5(pwd,promotionManageEmployeeDO.getPasswork())){
            throw new ParamException(RCode.LOGIN_PASSWORD_ERROR,null);
        }

        return transitionDto(promotionManageEmployeeDO);
    }

    @Override
    public PromotionManageEmployeeDto selectById(Integer employeeId) {
        return transitionDto(promotionManageEmployeeMapper.selectById(employeeId));
    }

    @Override
    public PromotionManageEmployeeDto selectOne(ManageEmployeeWrapper ewrap) {
        LambdaQueryWrapper<PromotionManageEmployeeDO> qw = builderOneWrapper(ewrap);
        if (qw.isEmptyOfWhere()){
            return null;
        }
        return transitionDto(promotionManageEmployeeMapper.selectOne(qw));
    }

    @Override
    public List<PromotionManageEmployeeDto> selectList(ManageEmployeeWrapper ewrap) {
        LambdaQueryWrapper<PromotionManageEmployeeDO> qw = builderWrapper(ewrap);
        List<PromotionManageEmployeeDO> dos = promotionManageEmployeeMapper.selectList(qw);
        return transitionDtos(dos);
    }

    private LambdaQueryWrapper<PromotionManageEmployeeDO> builderOneWrapper(ManageEmployeeWrapper ewrap){
        LambdaQueryWrapper<PromotionManageEmployeeDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(ewrap.getId())){
            qw.eq(PromotionManageEmployeeDO::getId,ewrap.getId());
        }
        if (Objects.nonNull(ewrap.getQcId())){
            qw.eq(PromotionManageEmployeeDO::getQcId,ewrap.getQcId());
        }
        if (Objects.nonNull(ewrap.getEmployeeNo())){
            qw.eq(PromotionManageEmployeeDO::getEmployeeNo,ewrap.getEmployeeNo());
        }
        return qw;
    }

    private LambdaQueryWrapper<PromotionManageEmployeeDO> builderWrapper(ManageEmployeeWrapper ewrap){
        LambdaQueryWrapper<PromotionManageEmployeeDO> qw = new LambdaQueryWrapper<>();
        if (ewrap.isHasDeptQcId()){
            qw.ne(PromotionManageEmployeeDO::getDeptQcId,"");
        }
        return qw;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param dos DO对象List
     * @return DTO对象
     */
    private List<PromotionManageEmployeeDto> transitionDtos(List<PromotionManageEmployeeDO> dos) {
        if (CollectionUtils.isEmpty(dos)) {
            return new ArrayList<>();
        }

        List<PromotionManageEmployeeDto> dtos = new ArrayList<>(dos.size() * 2);
        for (PromotionManageEmployeeDO edo : dos) {
            dtos.add(transitionDto(edo));
        }
        return dtos;
    }

    private PromotionManageEmployeeDto transitionDto(PromotionManageEmployeeDO employeeDO) {
        PromotionManageEmployeeDto dto = null;
        if (Objects.isNull(employeeDO)) {
            return dto;
        }
        dto = new PromotionManageEmployeeDto();
        BeanUtils.copyProperties(employeeDO, dto);
        return dto;
    }


}
