package com.wangxiaolu.promotion.domain.activity.dao;

import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;

import java.util.List;
import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2024-05-09 11
 * @describe :
 */
public interface TemporaryActivityPhotoDao {

    /**
     * 保存活动上报照片list
     */
    void saveReportedList(Integer temporaryId, Long reportedId, Integer photoType, List<String> urls, List<String> changeUrls);

    /**
     * 保存促销员上下班打卡图片
     */
    void saveClockPhoto(Integer temporaryId, Long clockId, Integer photoType, String url);

    /**
     * 根据促销员id-活动上报id查询图片
     */
    Map<Integer, List<String>> findReportedGroup(Integer temporaryId, Long reportedId);

    Map<Integer, TemporaryActivityPhotoDto> findClockPhotoGroupByClockId(Long clockId);

    void updateStatus(TemporaryPhotoWrapper pw, int status);

    void saveClockPhotoByUpdate(Integer temporaryId, Long id, Integer photoType, String url);

    Map<Long, Map<Integer, String>> findClockPhotoGroupByClockIds(List<Long> clockIds);

    Map<Integer, List<TemporaryActivityPhotoDto>> findReportedInfoGroup(Integer temporaryId, Long reportedId);
}
