package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import com.wangxiaolu.promotion.enums.activity.ClockType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author : liqiulin
 * @date : 2024-04-23 14
 * @describe :促销员打卡数据DTO
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class TemporaryClockDto {
    /**
     * 打卡记录id
     * 上班打卡无记录id
     */
    Long id;

    /**
     * temporaryId
     */
    Integer temporaryId;

    String temporaryName;

    Long planId;

    /**
     * 关联活动上报id
     */
    Long reportedId;

    Long storeId;

    String dealerName;

    String lineName;

    /**
     * qince_clientele_store表store_name
     */
    String storeName;
    private String qinceStoreCode;

    String deptQcId;

    String deptQcOrgName;

    String chargerQcId;

    String chargerName;

    // 上班打卡地址
    String clockInAddress;

    // 上班打卡经纬度
    String clockInCoordinates;

    // 上班打卡图片
    String clockInPhoto;

    Date clockInPhotoUpdateTime;

    // 上班打卡时间
    Date clockInTime;

    // 打卡所在地-省
    String clockProvince;

    // 打卡所在地-市
    String clockCity;

    // 午休下班打卡地点
    String noonClockOutAddress;

    // 午休下班打卡经纬度
    String noonClockOutCoordinates;

    // 午休下班打卡图片
    String noonClockOutPhoto;

    Date noonClockOutPhotoUpdateTime;

    // 午休下班打卡时间
    Date noonClockOutTime;

    // 午休上班打卡地点
    String noonClockInAddress;

    // 午休上班打卡经纬度
    String noonClockInCoordinates;

    // 午休上班打卡图片
    String noonClockInPhoto;

    Date noonClockInPhotoUpdateTime;

    // 午休上班打卡时间
    Date noonClockInTime;

    // 下班打卡地点
    String clockOutAddress;

    // 下班打卡经纬度
    String clockOutCoordinates;

    // 下班打卡图片
    String clockOutPhoto;

    Date clockOutPhotoUpdateTime;

    // 下班打卡时间
    Date clockOutTime;

    // 创建日期YYYY-MM-DD
    String createDate;

    // 活动模式Id
    Integer activityPatternId;

    // 活动模式
    String activityPattern;

    // 临时打卡图片
    String brevityClockPhoto;

    // 临时打卡类型
    Integer brevityClockType;


    /**
     * 是否删除
     * 1:有效；0：删除；
     */
    Integer isDelete;

    public TemporaryClockDto(Integer clockType, Long id, Integer temporaryId, String temporaryName, String clockProvince, String clockCity) {
        if (!ClockType.TEMPORARY_CLOCK_IN.equals(clockType)) {
            this.id = id;
        }
        this.temporaryId = temporaryId;
        this.temporaryName = temporaryName;
        this.clockProvince = clockProvince;
        this.clockCity = clockCity;
    }

    public TemporaryClockDto(Long id, Integer temporaryId, String brevityClockPhoto, Integer brevityClockType) {
        this.id = id;
        this.temporaryId = temporaryId;
        this.brevityClockPhoto = brevityClockPhoto;
        this.brevityClockType = brevityClockType;
    }
}
