package com.wangxiaolu.promotion.controller.activity.manage.tem;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.TemporaryInfoVo;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemporaryInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-07-31 15
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/core/temporary")
public class EmployeeCoreTemporaryInfoController {

    @Autowired
    EmployeeCoreTemporaryInfoService employeeCoreTemporaryInfoService;

    /**
     * 修改员工详情
     * @param temporaryInfoVo 修改后的员工信息
     * @return 是否成功
     */
    @PutMapping("/Info")
    public R updateTemporaryInfoById(@RequestBody TemporaryInfoVo temporaryInfoVo) {
        if (Objects.isNull(temporaryInfoVo.getId())){
            throw new ParamException(RCode.DATA_NOT_HAVE_ERROR);
        }
        WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
        temporaryDto.setId(temporaryInfoVo.getId())
                .setDeptQcId(temporaryInfoVo.getDeptQcId())
                .setDeptQcOrgName(temporaryInfoVo.getDeptQcOrgName())
                .setChargerQcId(temporaryInfoVo.getChargerQcId())
                .setChargerName(temporaryInfoVo.getChargerName());

        employeeCoreTemporaryInfoService.updateTemporaryInfoById(temporaryDto);
        return R.success();
    }
}
