package com.wangxiaolu.promotion.controller.activity.manage.tem;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.enums.plan.PlanStatus;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ClockVo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemClockService;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-07-17 19
 * @describe : 管理员修改员工打卡信息
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/core/clock")
public class EmployeeCoreTemClockController {

    @Autowired
    private EmployeeCoreTemClockService employeeCoreTemClockService;
    @Autowired
    private PromPlanCoreService promPlanCoreService;
    @Autowired
    private RedisCache redisCache;

    // 修改员工打卡形式
    @PutMapping("/update")
    public R updateClockactivityPattern(@RequestBody ClockVo clockVo) {
        TemporaryClockDto temporaryClockDto = new TemporaryClockDto();
        temporaryClockDto.setId(clockVo.getId())
                .setActivityPatternId(clockVo.getActivityPatternId())
                .setActivityPattern(redisCache.getHash(RedisKeys.TemporaryKeys.TENOIRART_ACTIVITY_PATTERN.getKey(),
                        String.valueOf(clockVo.getActivityPatternId())));
        employeeCoreTemClockService.updateClockactivityPattern(temporaryClockDto);
        return R.success();
    }

    @Transactional(rollbackFor = Exception.class)
    @DeleteMapping("/delete/{id}")
    public R deleteClockById(@PathVariable("id") long id){
        // 删除打卡记录
        Long planId = employeeCoreTemClockService.deleteClockById(id);

        // 把计划状态改为未执行
        promPlanCoreService.updatePlanStatus(planId, PlanStatus.NOT_EXECUTION);
        return R.success();
    }



}
