package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityClockDaoImpl implements TemporaryActivityClockDao {
    @Autowired
    TemporaryActivityClockMapper temporaryActivityClockMapper;

    @Override
    public void save(TemporaryClockDto dto) {
        // 避免重复打卡
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(dto.getTemporaryId())
                .setCreateDate(DateUtil.today());
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        Integer count = temporaryActivityClockMapper.selectCount(qw);
        if (count > 0) {
            return;
        }

        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        clockDo.setCreateDate(DateUtil.today());
        temporaryActivityClockMapper.insert(clockDo);
        dto.setId(clockDo.getId());
    }

    @Override
    public void updateById(TemporaryClockDto dto) {
        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto, clockDo);
        temporaryActivityClockMapper.updateById(clockDo);
    }

    /**
     * @param tcw 查询条件
     * @return 上述条件只能满足一条记录
     */
    @Override
    public TemporaryClockDto selectOne(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = buildWrapper(tcw);
        TemporaryActivityClockDO clockDO = temporaryActivityClockMapper.selectOne(qw);
        return transitionDto(clockDO);
    }

    @Override
    public void employeePage(String employeeQcId, PageInfo pageInfo,TemporaryClockWrapper tcw) {
        int skipNum = pageInfo.getSkipNum();
        List<TemporaryActivityClockDO> clockDOS = temporaryActivityClockMapper.employeePageFirsd(employeeQcId, pageInfo.getPageSize(), skipNum, tcw);
        if (Objects.isNull(clockDOS)) {
            throw new DataException(RCode.DATA_NOT_HAVE_ERROR);
        }

        List<TemporaryClockDto> temporaryClockDtos = transitionDtos(clockDOS);
        pageInfo.setRecords(temporaryClockDtos);

        // 查询总数
        Integer total = temporaryActivityClockMapper.employeePageCount(employeeQcId, pageInfo.getPageSize());
        pageInfo.setTotalRecord(total);
    }

    private LambdaQueryWrapper<TemporaryActivityClockDO> buildWrapper(TemporaryClockWrapper tcw) {
        LambdaQueryWrapper<TemporaryActivityClockDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(tcw.getId())) {
            qw.eq(TemporaryActivityClockDO::getId, tcw.getId());
            return qw;
        }

        if (Objects.nonNull(tcw.getTemporaryId())) {
            qw.eq(TemporaryActivityClockDO::getTemporaryId, tcw.getTemporaryId());
        }

        if (StringUtils.isNotBlank(tcw.getCreateDate())) {
            qw.eq(TemporaryActivityClockDO::getCreateDate, tcw.getCreateDate());
        }
        return qw;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryClockDto> transitionDtos(List<TemporaryActivityClockDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<TemporaryClockDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryActivityClockDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    private TemporaryClockDto transitionDto(TemporaryActivityClockDO clockDO) {
        TemporaryClockDto dto = null;
        if (Objects.isNull(clockDO)) {
            return dto;
        }
        dto = new TemporaryClockDto();
        BeanUtils.copyProperties(clockDO, dto);
        return dto;
    }
}
