package com.wangxiaolu.promotion.service.user.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.QinceDealerDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.DealerWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeDealerDto;
import com.wangxiaolu.promotion.service.user.QinCeDealerQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-09-02 13
 * @describe :
 */
@Service
public class QinCeDealerQueryServiceImpl implements QinCeDealerQueryService {

    @Autowired
    QinceDealerDao qinceDealerDao;

    @Override
    public void page(PageInfo pageInfo) {
        DealerWrapper dealerWrapper = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), DealerWrapper.class);
        qinceDealerDao.page(pageInfo,dealerWrapper);
    }

    @Override
    public List<QinCeDealerDto> findList(String dealerName) {
        DealerWrapper dw = new DealerWrapper();
        dw.setDealerName(dealerName);
        List<QinCeDealerDto> dtos = qinceDealerDao.selectList(dw);
        return dtos;
    }
}
