package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityReportedMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 10
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityReportedDaoImpl implements TemporaryActivityReportedDao {

    @Autowired
    TemporaryActivityReportedMapper temporaryActivityReportedMapper;

    /**
     * 保存促销员任务
     */
    @Override
    public long activityDataSave(TemporaryActivityReportedDto temActDto) {
        TemporaryActivityReportedDO tDo = new TemporaryActivityReportedDO();
        BeanUtils.copyProperties(temActDto, tDo);

        tDo.setApproveStatus(temActDto.getApproveStatus().name());
        tDo.setCreateDate(DateUtil.today());

        temporaryActivityReportedMapper.insert(tDo);
        return tDo.getId();
    }

    /**
     * 分页查询数据
     */
    @Override
    public void findPage(TemporaryActivityWrapper taw, PageInfo pageInfo) {
        LambdaQueryWrapper<TemporaryActivityReportedDO> temQw = buildQueryList(taw);

        Page<TemporaryActivityReportedDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<TemporaryActivityReportedDO> temDoPage = temporaryActivityReportedMapper.selectPage(page, temQw);
        pageInfo.pageCovert(temDoPage);
        pageInfo.setRecords(transitionDtos(temDoPage.getRecords()));
    }

    /**
     * 根据促销员id查询今日任务
     */
    @Override
    public TemporaryActivityReportedDto findOneByCurrentDate(Long temporaryId) {
        TemporaryActivityWrapper taw = new TemporaryActivityWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(DateUtil.today());
        LambdaQueryWrapper<TemporaryActivityReportedDO> temQw = buildQueryList(taw);
        TemporaryActivityReportedDO temDO = temporaryActivityReportedMapper.selectOne(temQw);
        return transitionDto(temDO);
    }

    @Override
    public TemporaryActivityReportedDto findOneById(Long id) {
        TemporaryActivityReportedDO temDO = temporaryActivityReportedMapper.selectById(id);
        return transitionDto(temDO);
    }

    @Override
    public void updateById(TemporaryActivityReportedDto temActDto) {
        TemporaryActivityReportedDO rDo = new TemporaryActivityReportedDO();
        BeanUtils.copyProperties(temActDto, rDo);
        if (Objects.nonNull(temActDto.getApproveStatus())) {
            rDo.setApproveStatus(temActDto.getApproveStatus().name());
        }
        rDo.setModifyTime(new Date());
        temporaryActivityReportedMapper.updateById(rDo);
    }

    @Override
    public List<TemporaryActivityReportedDto> findList(TemporaryActivityWrapper taw) {
        LambdaQueryWrapper<TemporaryActivityReportedDO> qw = buildQueryList(taw);
        List<TemporaryActivityReportedDO> dos = temporaryActivityReportedMapper.selectList(qw);
        return transitionDtos(dos);
    }

    private LambdaQueryWrapper<TemporaryActivityReportedDO> buildQueryList(TemporaryActivityWrapper tw) {
        LambdaQueryWrapper<TemporaryActivityReportedDO> queryWrapper = new LambdaQueryWrapper<>();
        if (Objects.nonNull(tw.getTemporaryId())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getTemporaryId, tw.getTemporaryId());
        }
        if (!StringUtils.isEmpty(tw.getCreateDate())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getCreateDate, tw.getCreateDate());
        }
        if (!StringUtils.isEmpty(tw.getApproveStatus())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getApproveStatus, tw.getApproveStatus());
        }
//        if (!StringUtils.isEmpty(tw.getApproverId())) {
//            queryWrapper.eq(TemporaryActivityReportedDO::getApproverId, tw.getApproverId());
//        }
        if (Objects.nonNull(tw.getManageId())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getManageId, tw.getManageId());
        }
        if (!StringUtils.isEmpty(tw.getDeptQcId())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getDeptQcId, tw.getDeptQcId());
        }
        if (!StringUtils.isEmpty(tw.getNotApproveStatus())) {
            queryWrapper.ne(TemporaryActivityReportedDO::getApproveStatus, tw.getNotApproveStatus());
        }
        if (!StringUtils.isEmpty(tw.getTemporaryName())) {
            queryWrapper.like(TemporaryActivityReportedDO::getTemporaryName, tw.getTemporaryName());
        }
        if (!StringUtils.isEmpty(tw.getProvince())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getProvince, tw.getProvince());
        }
        if (!StringUtils.isEmpty(tw.getCity())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getCity, tw.getCity());
        }
        if (tw.rangeDate()) {
            queryWrapper.between(TemporaryActivityReportedDO::getCreateTime, tw.getCreateDateStart(), tw.getCreateDateEnd());
        }
        if (!StringUtils.isEmpty(tw.getStoreNameLike())){
            queryWrapper.like(TemporaryActivityReportedDO::getStoreName,tw.getStoreNameLike());
        }
        if (Objects.nonNull(tw.getPlanId())){
            queryWrapper.eq(TemporaryActivityReportedDO::getPlanId,tw.getPlanId());
        }
        queryWrapper.eq(TemporaryActivityReportedDO::getIsDelete, StatusType.VALID.getType());
        // 默认创建日期倒序排列
        queryWrapper.orderByDesc(TemporaryActivityReportedDO::getId);
        return queryWrapper;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryActivityReportedDto> transitionDtos(List<TemporaryActivityReportedDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<TemporaryActivityReportedDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryActivityReportedDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDo DO对象
     * @return DTO对象
     */
    private TemporaryActivityReportedDto transitionDto(TemporaryActivityReportedDO temDo) {
        TemporaryActivityReportedDto temporaryDto = null;
        if (Objects.isNull(temDo)) {
            return temporaryDto;
        }

        temporaryDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(temDo, temporaryDto);
        // 审批状态回显
        if (Objects.nonNull(temDo.getApproveStatus())) {
            temporaryDto.setApproveStatus(TemActApproveStatus.valueOf(temDo.getApproveStatus()));
            temporaryDto.setApproveStatusMsg(temporaryDto.getApproveStatus().getMsg());
        }
        return temporaryDto;
    }
}
