package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityTaskClockDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityTaskClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityTaskWrapperDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryTaskClockDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityTaskClockDaoImpl implements TemporaryActivityTaskClockDao {
    @Autowired
    TemporaryActivityTaskClockMapper temporaryActivityTaskClockMapper;

    @Override
    public List<TemporaryActivityTaskClockDO> selectList(TemporaryActivityTaskWrapperDto wrapper) {
        List<TemporaryActivityTaskClockDO> temporaryActivityTaskClockDOS = temporaryActivityTaskClockMapper.selectList(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                .eq(ObjectUtil.isNotEmpty(wrapper.getTemporaryId()), TemporaryActivityTaskClockDO::getTemporaryId, wrapper.getTemporaryId())
                .eq(ObjectUtil.isNotEmpty(wrapper.getUserId()), TemporaryActivityTaskClockDO::getTemporaryId, wrapper.getUserId())
                .eq(ObjectUtil.isNotEmpty(wrapper.getIsDelete()), TemporaryActivityTaskClockDO::getIsDelete, wrapper.getIsDelete())
                .orderByAsc(TemporaryActivityTaskClockDO::getTaskType));

        return temporaryActivityTaskClockDOS;
    }

    @Override
    public void save(TemporaryActivityTaskClockDO taskClockDO) {
        temporaryActivityTaskClockMapper.insert(taskClockDO);

    }

    @Override
    public TemporaryActivityTaskClockDO selectById(Long id) {
        return temporaryActivityTaskClockMapper.selectById(id);
    }

    @Override
    public void update(TemporaryActivityTaskClockDO taskClockDO) {
        temporaryActivityTaskClockMapper.updateById(taskClockDO);
    }

    @Override
    public TemporaryActivityTaskClockDO selectOne(TemporaryActivityTaskWrapperDto wrapper) {
        TemporaryActivityTaskClockDO temporaryActivityTaskClockDO = temporaryActivityTaskClockMapper.selectOne(new LambdaQueryWrapper<TemporaryActivityTaskClockDO>()
                .eq(TemporaryActivityTaskClockDO::getTemporaryId, wrapper.getTemporaryId())
                .eq(TemporaryActivityTaskClockDO::getTaskType, wrapper.getTaskType())
                .eq(TemporaryActivityTaskClockDO::getIsDelete, wrapper.getIsDelete()));

        return temporaryActivityTaskClockDO;
    }

    @Override
    public void updateTaskClock(TemporaryTaskClockDto updateTaskClockDto) {
        TemporaryActivityTaskClockDO updateTaskClockDo = BeanUtils.transitionDto(updateTaskClockDto, TemporaryActivityTaskClockDO.class);
        temporaryActivityTaskClockMapper.updateById(updateTaskClockDo);

    }
}
