package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.pojo.user.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityCoreServiceImpl implements TemporaryActivityCoreService {

    // 活动上报
    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    // 打卡数据
    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;

    @Autowired
    QinCeClienteleStoreDao qinCeClienteleStoreDao;


    /**
     * 活动上报保存
     * @return 生成id
     */
    @Override
    public long activityDataReportedSave(TemporaryActivityReportedDto temActDto) {
        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED);

        // 根据storeQcId查询店铺信息
        QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(new StoreWrapper().setQcId(temActDto.getStoreQcId()));
        temActDto.setStoreName(storeDto.getStoreName()).setStoreAddr(storeDto.getStoreAddr());

        return temporaryActivityReportedDao.activityDataSave(temActDto);
    }

    /**
     * 促销员当日打卡信息保存
     */
    @Override
    public void clockInTodayActivity(TemporaryClockDto dto) {
        if (Objects.isNull(dto.getId())){
            temporaryActivityClockDao.save(dto);
            return;
        }
        temporaryActivityClockDao.updateById(dto);
    }

    /**
     * 活动信息修改
     * 1、判断活动是否可以修改
     */
    @Override
    public void activityDataReportedUpdate(TemporaryActivityReportedDto temActDto) {
        temporaryActivityReportedDao.updateById(temActDto);
    }
}
