package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.user.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * @author : liqiulin
 * @date : 2024-04-23 18
 * @describe : 打卡信息查询
 */
@Slf4j
@RestController
@RequestMapping("/temporary/clock/query")
public class TemporaryActivityClockQueryController {

    @Autowired
    TemporaryActivityClockQueryService temporaryActivityClockQueryService;


    /**
     * 根据促销员id查询今日打卡信息
     */
    @GetMapping("/{temporary_id}")
    public TemporaryClockDto findTodayTemporaryClockByTemId(@PathVariable("temporary_id") @NotNull Integer temporaryId){
        return temporaryActivityClockQueryService.findTodayTemporaryClockByTemId(temporaryId);
    }
}
