package com.wangxiaolu.promotion.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
@Service
public class WeChatUserQueryServiceImpl implements WeChatUserQueryService {

    private static final Logger log = LoggerFactory.getLogger(WeChatUserQueryServiceImpl.class);
    @Autowired
    TemporaryInfoDao temporaryInfoDao;

    @Override
    public boolean loginTemporaryByOpenId(String userOpenId) {
        TemporaryInfoDO temDo = temporaryInfoDao.queryOneTemporaryByOpenId(userOpenId);
        boolean exist = !Objects.isNull(temDo);

        // todo 查询到时，将个人信息放到reids中进行保存
        if (exist) {
            log.info("{}登录成功，openId：{}", temDo.getName(), userOpenId);
            log.info(JSONObject.toJSONString(temDo));
        }

        return exist;
    }
}
