package com.wangxiaolu.promotion.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import com.wangxiaolu.promotion.utils.JwtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 18
 * @describe :微信人员信息查询
 */
@Service
public class WeChatUserQueryServiceImpl implements WeChatUserQueryService {

    private static final Logger log = LoggerFactory.getLogger(WeChatUserQueryServiceImpl.class);
    @Autowired
    TemporaryInfoDao temporaryInfoDao;
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;

    /**
     * 根据openId、手机号登录
     */
    @Override
    public boolean loginTemporaryByOpenIdAndPhone(String openId, String phone) {
        WxTemporaryInfoDto temDto = temporaryInfoDao.getUnimportantData(openId, phone);
        boolean exist = !Objects.isNull(temDto);

        if (exist) {
            log.info("微信-促销员{}登录成功(openId、手机号)，openId：{}，phone：{}", temDto.getName(), openId, phone);
            log.info(JSONObject.toJSONString(temDto));
        } else {
            log.info("微信-促销员登录失败，当前信息未注册(openId、手机号)，openId：{}，phone：{}", openId, phone);
        }

        return exist;
    }

    /**
     * 不返回身份证照片等重要信息，详情请查看sql语句
     */
    @Override
    public WxTemporaryInfoDto getTemporaryByToken(String openId) {
        // todo 先查询redis中是否有缓存数据
        String key = RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey();

        // todo redis中没有缓存数据，则进行查询
        WxTemporaryInfoDto temporaryInfoDto = temporaryInfoDao.getUnimportantData(openId);
        if (Objects.isNull(temporaryInfoDto)) {
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, null);
        }

        return temporaryInfoDto;
    }

    @Override
    public WxTemporaryInfoDto getTemporaryByToken(String openId, String phone) {
        return null;
    }

}
