package com.wangxiaolu.promotion.controller.wechat;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxTemporaryLoginVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserQueryService;
import com.wangxiaolu.promotion.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-09 13
 * @describe :微信用户信息查询
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/query")
public class WeChatUserQueryController {

    @Autowired
    private WeChatUserQueryService weChatUserQueryService;

    /**
     * 根据OpenId、Phone登录（促销员查询是否存在）
     * @return  非null则登录成功
     */
    @PostMapping("/temporary/login/phone_openid")
    public boolean temporaryLoginByPhoneAndOpenId(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        if (!DataUtils.phonePattern(wxTemporaryLoginVo.getPhone())) {
            throw new ParamException(RCode.PHONE_PARAM_ERROR, null);
        }
        return weChatUserQueryService.loginTemporaryByOpenIdAndPhone(wxTemporaryLoginVo.getOpenId(), wxTemporaryLoginVo.getPhone());
    }


    /**
     * 促销员信息查询
     */
    @GetMapping("/temporary/phone_openid")
    public WxTemporaryInfoDto getTemporaryInfoByOpenId(@RequestBody WxTemporaryLoginVo wxTemporaryLoginVo) {
        return weChatUserQueryService.getTemporaryByToken(wxTemporaryLoginVo.getOpenId(),wxTemporaryLoginVo.getPhone());
    }
}
