package com.wangxiaolu.promotion.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-03-29 18
 * @describe : 勤策 api请求配置
 */
@Component
@Slf4j
public class QinCeUtils {

    /**
     * =================== 勤策API - config ===================
     */
    @Value("${qince.open_api}")
    private String OPEN_API;
    @Value("${qince.open_id}")
    private String OPEN_ID;
    @Value("${qince.app_key}")
    private String APP_KEY;


    /**
     * =================== 勤策API - path ===================
     */
    // 部门、组织架构
    public static final String QUERY_ORGANIZATION = "/api/organization/v1/queryOrganization/";
    // 员工列表
    public static final String QUERY_EMPLOYEE = "/api/employee/v3/queryEmployee/";
    // 终端（商店）列表
    public static final String QUERY_SHORE = "/api/store/v1/queryStore/";
    // 客户位置偏差查询
    public static final String CAL_DISTANCE = "/api/cmLocation/v1/calDistance/";
    // 商品类型查询
    public static final String QUERY_PRODUCT_PD_TYPE = "/api/product/v1/queryPdType/";
    // 商品列表
    public static final String QUERY_PRODUCT = "/api/product/v1/queryProduct/";
    // 经销商
    public static final String QUERY_DEALER = "/api/dealer/v1/queryDealer/";

    public String builderUrl(String sidepath, Map<String, Object> params) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();

        String digest = getDigest(params, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    public String builderUrlList(String sidepath, List<Map> paramList) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();

        String digest = getDigest(paramList, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    /**
     * 查询[部门]参数
     */
    public Map<String, Object> productQueryPdTypeParam() {
        Map<String, Object> params = new HashMap<>();
        params.put("type_name", "");
        params.put("type_id", "");
        return params;
    }

    /**
     * 全量 查询[部门]参数
     */
    public Map<String, Object> queryOrgParam() {
        Map<String, Object> params = new HashMap<>();
        DateTime dateTime = DateUtil.offsetDay(new Date(), -1);
        params.put("modify_date", DateUtil.format(dateTime, DatePattern.NORM_DATE_PATTERN));
        return params;
    }

    /**
     * 查询[人员]参数
     */
    public Map<String, Object> queryEmployeeParam(int offset) {
        Map<String, Object> params = new HashMap<>();
        // 根据来源勤策的员工唯一标识精确查询
//        if (queryId) {
//            params.put("id", "");
//        }
        DateTime dateTime = DateUtil.offsetDay(new Date(), offset);
        params.put("modify_date", DateUtil.format(dateTime, DatePattern.NORM_DATE_PATTERN));
        return params;
    }

    /**
     * 查询[人员]参数
     */
    public Map<String, Object> queryEmployeeAllParam() {
        Map<String, Object> params = new HashMap<>();
//        0：删除，1：正常，2：停用
        params.put("emp_status", "1");
        return params;
    }

    /**
     * 查询[客户管理-终端]参数
     */
    public Map<String, Object> queryShopParam(Integer pageNum) {
        HashMap<String, Object> params = new HashMap<>();
        // 分页页码，默认1
        params.put("page_number", pageNum);
        // 查询指定数据 params.put("store_code", "POS00040423"); after_modify_date：查询更新时间(2小时之内)的门店数据。格式：yyyy-MM-dd HH:mm:SS
//        DateTime dateTime = DateUtil.offsetDay(new Date(), -1);
        DateTime dateTime = DateUtil.offsetHour(new Date(), -1);
        params.put("after_modify_date", DateUtil.format(dateTime, DatePattern.NORM_DATETIME_PATTERN));
        return params;
    }

    /**
     * 客户位置偏差查询 参数
     * longitude:经度
     * latitude:纬度
     */
    public List<Map> queryCalDistanceParam(String storeQcId, String longitude, String latitude) {
        Map<String, Object> params = new HashMap<>();
        params.put("qince_customer_id", storeQcId);
        params.put("longitude", longitude);
        params.put("latitude", latitude);
        return Arrays.asList(params);
    }

    private String getDigest(Map<String, Object> params, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(params)) {
            json = JSONObject.toJSONString(params);
        }
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }

    private String getDigest(List<Map> paramList, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(paramList)) {
            json = JSONObject.toJSONString(paramList);
        }
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }

    public Map<String, Object> queryProductParam() {
        Map<String, Object> params = new HashMap<>();
        params.put("prd_id", "");
        return params;
    }

    /**
     * 同步「经销商」数据
     */
    public Map<String, Object> queryDealerParam(Integer pageNum) {
        Map<String, Object> params = new HashMap<>();
        params.put("page_number", pageNum);

        // 全量数据同步后，再开启指定日期同步
//        DateTime dateTime = DateUtil.offsetDay(new Date(), -1);
//        params.put("after_create_date", DateUtil.format(dateTime, DatePattern.NORM_DATETIME_PATTERN));
        return params;
    }
}
