package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionStoreDao;
import com.wangxiaolu.promotion.domain.activity.mapper.PromotionStoreMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.PromotionStoreDO;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.PromotionStoreWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-18 13
 * @describe :
 */
@Service
@Slf4j
public class PromotionStoreDaoImpl implements PromotionStoreDao {

    @Autowired
    PromotionStoreMapper promotionStoreMapper;

    /**
     * 保存店铺
     */
    @Override
    public void save(PromotionStoreDto promotionStoreDto) {
        PromotionStoreDO storeDo = new PromotionStoreDO();
        BeanUtils.copyProperties(promotionStoreDto, storeDo);
        promotionStoreMapper.insert(storeDo);
        log.info("录入店铺：{}", JSONObject.toJSONString(storeDo));
    }

    @Override
    public List<PromotionStoreDto> findList(PromotionStoreWrapper promotionStoreWrapper) {
        LambdaQueryWrapper<PromotionStoreDO> qw = buildWrapper(promotionStoreWrapper);
        qw.select(PromotionStoreDO::getStoreName,PromotionStoreDO::getId);

        List<PromotionStoreDO> promotionStoreDOS = promotionStoreMapper.selectList(qw);
        return transitionDtos(promotionStoreDOS);
    }

    @Override
    public PromotionStoreDto selectOneById(Long id) {
        PromotionStoreDO promotionStoreDO = promotionStoreMapper.selectById(id);
        return transitionDto(promotionStoreDO);
    }

    private LambdaQueryWrapper<PromotionStoreDO> buildWrapper(PromotionStoreWrapper promotionStoreWrapper){
        LambdaQueryWrapper<PromotionStoreDO> lqw = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(promotionStoreWrapper.getArea())){
            lqw.eq(PromotionStoreDO::getArea,promotionStoreWrapper.getArea());
        }
        return lqw;
    }


    /**
     * DO to DTO (单个对象)
     *
     * @param storeDos DO对象List
     * @return DTO对象
     */
    private List<PromotionStoreDto> transitionDtos(List<PromotionStoreDO> storeDos) {
        if (CollectionUtils.isEmpty(storeDos)) {
            return new ArrayList<>();
        }

        List<PromotionStoreDto> dtos = new ArrayList<>(storeDos.size() * 2);
        for (PromotionStoreDO storeDo : storeDos) {
            dtos.add(transitionDto(storeDo));
        }
        return dtos;
    }

    private PromotionStoreDto transitionDto(PromotionStoreDO storeDo) {
        PromotionStoreDto dto = null;
        if (Objects.isNull(storeDo)) {
            return dto;
        }
        dto = new PromotionStoreDto();
        BeanUtils.copyProperties(storeDo, dto);
        return dto;
    }

}
