package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityDataVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员活动上报、修改
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/core")
public class TemporaryActivityCoreController {

    @Autowired
    private TemporaryActivityCoreService tempActivityCoreService;

    /**
     * 促销员[今日活动]数据保存
     * 返回活动生成id
     */
    @PostMapping("/today/reported")
    public R todayActivityDataReported(@RequestBody TemporaryActivityDataVo activityVo) {
        TemporaryActivityReportedDto temActDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(activityVo, temActDto);
        temActDto.setId(activityVo.getActivityReportedId());

        // 有ID则修改，无ID则新建
        if (Objects.nonNull(activityVo.getActivityReportedId())) {
            tempActivityCoreService.activityDataReportedUpdate(temActDto);
            return R.success(activityVo.getActivityReportedId());
        }
        return R.success(tempActivityCoreService.activityDataReportedSave(temActDto));
    }

    /**
     * 促销员[今日活动]数据提交审批
     * 修改审批状态
     */
    @PutMapping("/reported/approve/submit/{id}")
    public R activityReportedSubmit(@PathVariable("id") Long id) {
        tempActivityCoreService.activityReportedSubmit(id);
        return R.success();
    }

}
