package com.wangxiaolu.promotion.controller.activity.temporary;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.enums.activity.ClockType;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryClockVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员活动上报、修改
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/core")
public class TemporaryActivityClockCoreController {

    @Autowired
    private TemporaryActivityCoreService tempActivityCoreService;

    /**
     * 促销员当日打卡信息保存
     */
    @PostMapping("/today/clock")
    public R clockInTodayActivity(@RequestBody TemporaryClockVo clockVo) {
        clockVo.validate();
        Integer clockType = clockVo.getClockType();
        boolean isClockIn = ClockType.TEMPORARY_CLOCK_IN.equals(clockType);
        // 上班卡必需有店铺id
        if (isClockIn && (Objects.isNull(clockVo.getStoreId()) || clockVo.getStoreId() <= 0)) {
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }
        // 非上班卡必需有打卡记录ID
        if (!isClockIn && Objects.isNull((clockVo.getId()))) {
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }

        // 根据打卡经纬度判断与打卡店铺的距离，距离超过100米不能打卡
//        tempActivityCoreService.clockStoreCalDistance(clockVo.getStoreQcId(),clockVo.getId(),clockVo.getClockCoordinates());

        /**
         * todo redis打卡-限制重复提交
         * todo 后续添加，基于redis
         */


        Date clockTime = new Date();
        TemporaryClockDto dto = new TemporaryClockDto(clockVo.getClockType(), clockVo.getId(), clockVo.getTemporaryId(), clockVo.getTemporaryName(), clockVo.getClockProvince(), clockVo.getClockCity());
        // 上班卡、午休下班卡、午休上班卡、下班卡
        if (isClockIn) {
            builderClockInData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_NOON_CLOCK_OUT.equals(clockType)) {
            builderNoonClockOutData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_NOON_CLOCK_IN.equals(clockType)) {
            builderNoonClockInData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_CLOCK_OUT.equals(clockType)) {
            builderClockOutData(clockVo, dto, clockTime);
        }
        tempActivityCoreService.clockInTodayActivity(dto, clockType);
        return R.success();
    }

    // 上班打卡
    private void builderClockInData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//        todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_CLOCK_IN_BEGIN_TIME, ClockType.TEMPORARY_CLOCK_IN_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }

        clockDto.setTemporaryId(clockVo.getTemporaryId())
                .setTemporaryName(clockVo.getTemporaryName())
                .setStoreId(clockVo.getStoreId())
                .setStoreName(clockVo.getStoreName())
                .setClockInAddress(clockVo.getClockAddress())
                .setClockInCoordinates(clockVo.getClockCoordinates())
                .setClockInPhoto(clockVo.getClockPhoto())
                .setClockInTime(dateTime);
    }

    // 午休下班卡
    private void builderNoonClockOutData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//       todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_NOON_CLOCK_OUT_BEGIN_TIME, ClockType.TEMPORARY_NOON_CLOCK_OUT_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }
        clockDto.setId(clockVo.getId())
                .setNoonClockOutAddress(clockVo.getClockAddress())
                .setNoonClockOutCoordinates(clockVo.getClockCoordinates())
                .setNoonClockOutPhoto(clockVo.getClockPhoto())
                .setNoonClockOutTime(dateTime);

    }

    // 午休上班卡
    private void builderNoonClockInData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//        todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_NOON_CLOCK_IN_BEGIN_TIME, ClockType.TEMPORARY_NOON_CLOCK_IN_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }
        clockDto.setId(clockVo.getId())
                .setNoonClockInAddress(clockVo.getClockAddress())
                .setNoonClockInCoordinates(clockVo.getClockCoordinates())
                .setNoonClockInPhoto(clockVo.getClockPhoto())
                .setNoonClockInTime(dateTime);
    }

    // 下班卡
    private void builderClockOutData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//        todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_CLOCK_OUT_BEGIN_TIME, ClockType.TEMPORARY_CLOCK_OUT_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }
        clockDto.setId(clockVo.getId())
                .setClockOutAddress(clockVo.getClockAddress())
                .setClockOutCoordinates(clockVo.getClockCoordinates())
                .setClockOutPhoto(clockVo.getClockPhoto())
                .setClockOutTime(dateTime);
    }


}
