package com.wangxiaolu.promotion.service.activity.manage.impl;

import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanInfoVo;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanInfoCoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-09-02 18
 * @describe :
 */
@Service
public class ActivityPlanInfoCoreServiceImpl implements ActivityPlanInfoCoreService {

    @Autowired
    EmployeeActivityPlanInfoDao employeeActivityPlanInfoDao;
    @Autowired
    QinCeClienteleStoreDao qinCeClienteleStoreDao;

    @Override
    public void updateActivityInfo(ActivityPlanInfoVo activityPlanInfoVo) {
        ActivityPlanInfoWrapper wrap = new ActivityPlanInfoWrapper();
        BeanUtils.copyProperties(activityPlanInfoVo, wrap);

        employeeActivityPlanInfoDao.update(wrap);
    }

    @Override
    public void save(ActivityPlanInfoVo activityPlanInfoVo) {
        EmployeeActivityPlanInfoDto dto = new EmployeeActivityPlanInfoDto();
        BeanUtils.copyProperties(activityPlanInfoVo, dto);

        // 无终端编码直接保存
        if (StringUtils.isBlank(activityPlanInfoVo.getQinceStoreCode())) {
            employeeActivityPlanInfoDao.saveList(Arrays.asList(dto));
            return;
        }

        // 有终端编码需要验证准确性且补充门店名称
        StoreWrapper storeWrap = new StoreWrapper()
                .setStoreCode(activityPlanInfoVo.getQinceStoreCode());
        QinCeClienteleStoreDto qcStore = qinCeClienteleStoreDao.getOneStore(storeWrap);
        if (Objects.isNull(qcStore)) {
            throw new ParamException(RCode.QINCE_STORE_CODE_ERROR);
        }
        dto.setQinceStoreName(qcStore.getStoreName());
        employeeActivityPlanInfoDao.saveList(Arrays.asList(dto));
    }
}
