package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.domain.user.dao.WxTemporaryInfoDelayDao;
import com.wangxiaolu.promotion.domain.user.mapper.entity.WxTemporaryInfoDelayDO;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.WxTemporaryInfoDelayDtO;
import com.wangxiaolu.promotion.service.user.WxTemporaryInfoDelayService;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class WxTemporaryInfoDelayServiceImpl implements WxTemporaryInfoDelayService {

    @Resource
    private WxTemporaryInfoDelayDao delayDao;

    @Override
    public boolean saveDelayData(WxTemporaryInfoDelayDtO delayEntity) {
        // 调用DAO插入数据（含storeCode/dataDate）
        return delayDao.insert(delayEntity) > 0;
    }

    @Override
    public List<WxTemporaryInfoDelayDtO> listUnprocessedData(LocalDateTime startTime, LocalDateTime endTime) {
        return delayDao.selectUnprocessedData(startTime, endTime);
    }

    @Override
    public boolean batchUpdateProcessedStatus(List<Long> idList, Integer isProcessed) {
        return delayDao.batchUpdateProcessedStatus(idList, isProcessed) > 0;
    }
}