package com.wangxiaolu.promotion.domain.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.WxTemporaryInfoDelayDO;
import org.apache.ibatis.annotations.Param;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 延迟临时表Mapper
 */
public interface WxTemporaryInfoDelayMapper extends BaseMapper<WxTemporaryInfoDelayDO> {
    /**
     * 查询指定时间范围内未处理的数据
     */
    List<WxTemporaryInfoDelayDO> selectByTimeAndStatus(
            @Param("startTime") LocalDateTime startTime,
            @Param("endTime") LocalDateTime endTime,
            @Param("isProcessed") Integer isProcessed
    );

    /**
     * 批量更新处理状态
     */
    int batchUpdateStatus(
            @Param("idList") List<Long> idList,
            @Param("isProcessed") Integer isProcessed
    );
}