package com.wangxiaolu.promotion.controller.activity.temporary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.PromotionStoreDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.PromotionStoreVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.temporary.PromotionStoreQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-06-18 15
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/activity/promotion/store/query")
public class PromotionStoreQueryController {

    @Autowired
    PromotionStoreQueryService promotionStoreQueryService;
    @Autowired
    RedisCache redisCache;

    /**
     * 查询店铺列表：目前不分页
     */
    @PostMapping("/list")
    public R findStoreList(@RequestBody PromotionStoreVo promotionStoreVo){
        List<PromotionStoreDto> storeDtos = promotionStoreQueryService.findStoreList(promotionStoreVo);
        return R.success(storeDtos);
    }

    @GetMapping("/line/names")
    public R findLineNameMap(String lineOrgName){
        JSONObject jo = redisCache.getToJson(RedisKeys.TemporaryKeys.TEMPORARY_SAVE_STORE_LINE_NAME.getKey());
        JSONArray lineNames = jo.getJSONArray(lineOrgName);
        return R.success(lineNames);
    }
}
