package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import com.wangxiaolu.promotion.common.util.MD5Utils;
import com.wangxiaolu.promotion.domain.activity.dao.PromotionManageEmployeeDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.PromotionManageEmployeeDto;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.WangxlEmployeeQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
@Slf4j
public class WangxlEmployeeQueryServiceImpl implements WangxlEmployeeQueryService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    PromotionManageEmployeeDao promotionManageEmployeeDao;


    @Override
    public String employeeLoginVerify(UserLoginParam userLoginParam) {
        PromotionManageEmployeeDto employeeDto = promotionManageEmployeeDao.selectOneByEmployeeNo(userLoginParam.getLoginName());
        if (Objects.isNull(employeeDto)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
        if (!MD5Utils.getSaltverifyMD5(userLoginParam.getPassword(),employeeDto.getPasswork())){
            throw new ParamException(RCode.LOGIN_PASSWORD_ERROR,null);
        }

        log.info("促销员管理后台登录成功，工号：{}", userLoginParam.getLoginName());
        String loginToken = jwtUtils.getEmployeeToken(userLoginParam.getLoginName(), userLoginParam.getPassword());
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey()+loginToken,employeeDto,360);
        return loginToken;

    }
}
