package com.wangxiaolu.promotion.controller.activity.employee;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeQueryTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-05-29 14
 * @describe : 员工查询促销员活动上报信息
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/query")
public class EmployeeQueryTemActivityController {

    @Autowired
    EmployeeQueryTemActivityService employeeQueryTemActivityService;

    /**
     * 查询员工负责审批的活动数据
     *
     * @param loginQcId 员工
     * @return 活动数据
     */
    @PostMapping("/page")
    public R findActivitys(@RequestHeader("loginQcId") String loginQcId, @RequestBody PageInfo pageInfo) {
        employeeQueryTemActivityService.getEmployeeApproveActivityPage(loginQcId, pageInfo);
        return R.success(pageInfo);
    }

}
