package com.wangxiaolu.promotion.service.activity.examine.impl;

import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.examine.dao.ActivityExamineDao;
import com.wangxiaolu.promotion.domain.inspection.dao.InspectionInfoDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.examine.dto.ActivityExamineDto;
import com.wangxiaolu.promotion.pojo.activity.inspectionInfo.dto.InspectionInfoDto;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.examine.ExaPlanCoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-04-02 15
 * @describe :
 */
@Service
public class ExaPlanCoreServiceImpl implements ExaPlanCoreService {

    @Autowired
    private ActivityExamineDao activityExamineDao;
    @Autowired
    private ActivityPlanInfoDao activityPlanInfoDao;

    @Autowired
    private InspectionInfoDao inspectionInfoDao;

    @Override
    public ActivityExamineDto save(ActivityExamineDto examineDto) {
        // 根据促销计划id得到详情并补充
        ActivityPlanInfoDto planInfoDto = activityPlanInfoDao.selectById(examineDto.getPlanId());
        if (Objects.isNull(planInfoDto)) {
            throw new ParamException(RCode.ACTIVITY_PLAN_IS_NULL);
        }
        // 判断执行日期是否开始
        Date date = planInfoDto.getDate();
        if (date.after(new Date())) {
            throw new ParamException(RCode.ACTIVITY_NOT_START);
        }

        examineDto.setDeptQcOrgName(planInfoDto.getOrgName());
        examineDto.setManageName(planInfoDto.getEmployeeName());
        examineDto.setCity(planInfoDto.getCity());
        examineDto.setPlanDate(planInfoDto.getDate());
        examineDto.setLineName(planInfoDto.getLineName());
        examineDto.setStoreName(planInfoDto.getStoreName());
        examineDto.setDealerName(planInfoDto.getDealerName());
        examineDto.setPattern(planInfoDto.getPattern());
        return activityExamineDao.save(examineDto);
    }

    @Override
    public InspectionInfoDto saveV2(InspectionInfoDto inspectionInfoDto) {
        ActivityPlanInfoDto activityPlanInfoDto = activityPlanInfoDao.selectById(inspectionInfoDto.getPlanId());
        if (Objects.isNull(activityPlanInfoDto)) {
            throw new ParamException(RCode.ACTIVITY_PLAN_IS_NULL);
        }
        inspectionInfoDto.setDepQcOrgName(activityPlanInfoDto.getOrgName());
        inspectionInfoDto.setAddr(activityPlanInfoDto.getAddr());
        inspectionInfoDto.setDealerId(activityPlanInfoDto.getDealerId());
        inspectionInfoDto.setDealerName(activityPlanInfoDto.getDealerName());
        inspectionInfoDto.setStoreCode(activityPlanInfoDto.getStoreCode());
        inspectionInfoDto.setStoreName(activityPlanInfoDto.getStoreName());
        inspectionInfoDto.setPattern(activityPlanInfoDto.getPattern());
        inspectionInfoDto.setCreateTime(new Date());
        inspectionInfoDto.setCreateBy(inspectionInfoDto.getEmployeeName());
        return inspectionInfoDao.save(inspectionInfoDto);
    }

    @Override
    public InspectionInfoDto updateByIdV2(InspectionInfoDto inspectionInfoDto) {
        inspectionInfoDto.setModifyTime(new Date());
        inspectionInfoDto.setModifyBy(inspectionInfoDto.getEmployeeName());
        return inspectionInfoDao.updateById(inspectionInfoDto);
    }

    @Override
    public ActivityExamineDto updateById(ActivityExamineDto examineDto) {
        return activityExamineDao.updateById(examineDto);
    }


}
