package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author : liqiulin
 * @date : 2024-03-29 16
 * @describe :
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class QinCeEmployeeDto {
    /**
     * 主键id
     */
    private Integer id;

    /**
     * 勤策的员工唯一标识
     * 对应[QinCeEmployeeDTO.id]
     */
    private String qcId;

    /**
     * 来源第三方系统的员工唯一标识
     */
    private String empId;

    /**
     * 员工登录帐号
     */
    private String empCode;

    /**
     * 姓名
     */
    private String empName;

    /**
     * 员工别名
     */
    private String aliasName;

    /**
     * 人员编码
     */
    private String employeeCode;

    /**
     * 员工手机号码
     */
    private String empMobile;

    /**
     * 邮箱
     */
    private String empEmail;

    /**
     * 来源第三方系统隶属部门
     */
    private String empOrgId;

    /**
     * 隶属部门编码
     */
    private String empOrgCode;

    /**
     * 勤策部门唯一标识
     * 对应QinCeDepartmentDO.qcId
     */
    private String waiqin365OrgId;

    /**
     * 来源第三方系统,员工上级唯一标识
     */
    private String empParentId;

    /**
     * 员工账号状态。0：销户，1：正常，2：停用
     */
    private String empStatus;

    /**
     * 勤策经销商唯一标识
     */
    private String dealerId;

    /**
     * 经销商中文名称
     */
    private String dealerName;

    /**
     * 勤策职务唯一标识
     */
    private String waiqin365PositionId;

    /**
     * 职务编码
     */
    private String empPositionCode;

    /**
     * 职务名称
     */
    private String empPosition;

    /**
     * 勤策岗位唯一标识
     */
    private String waiqin365JobId;

    /**
     * 岗位编码
     */
    private String empJobCode;

    /**
     * 岗位名称
     */
    private String empJob;

}
