package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员今日活动上报VO
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityDataVo {
    /**
     * 促销员活动上报id
     * 关联ID：temporary_activity_reported表id
     */
    private Long activityReportedId;
    /**
     * 促销员id
     * temporaryInfo表id
     */
    private  Long temporaryId;

    /**
     * 促销员姓名
     * temporaryInfo表name
     */
    private String temporaryName;


    /**
     * 活动店铺Id
     */
//    private Long storeId;

    /**
     * 推广试吃照片
     */
    private List<String> tgscPhotoUrls;
    private List<String> tgscChangePhotoUrls;

    /**
     * 推广互动照片
     */
    private List<String> tghdPhotoUrls;
    private List<String> tghdChangePhotoUrls;

    /**
     * 推广成交照片
     */
    private List<String> tgcjPhotoUrls;
    private List<String> tgcjChangePhotoUrls;

    /**
     * POS机页面凭证
     * POS_SELL_VOUCHER
     * psv
     */
    private List<String> psvPhotoUrls;
    private List<String> psvChangePhotoUrls;
}
