package com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import lombok.Data;

/**
 * 活动计划列表
 * @TableName activity_plan_info
 */
@TableName(value ="activity_plan_info")
@Data
public class ActivityPlanInfoDo implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 活动计划表上传记录id
     */
    private Long planFileId;

    /**
     * promotion_manage_employee表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 月份
     */
    private Integer month;

    /**
     * 日期
     */
    private Date date;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 战区-勤策ID
     */
    private String orgQcId;

    /**
     * 战区名称
     */
    private String orgName;

    /**
     * 活动模式id
     */
    private Integer patternId;

    /**
     * 活动模式
     */
    private String pattern;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 是否双T门店
     */
    private String bothT;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    private String province;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    private String city;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    private String area;

    /**
     * 门店所在地址
     */
    private String addr;

    /**
     * 上班时间
     */
    private LocalDateTime clockInTime;

    /**
     * 午休下班时间
     * 强制更新，即使为null
     */

    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDateTime noonClockOutTime;
    /**
     * 午休上班时间
     * 强制更新，即使为null
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private LocalDateTime noonClockInTime;

    /**
     * 下班时间
     */
    private LocalDateTime clockOutTime;

    /**
     * 工资
     */
//    private BigDecimal salary;

    /**
     * 杂费
     */
//    private BigDecimal incidentals;

    /**
     * 是否有试吃台
     */
    private String temWlSct;
    /**
     * 活动品项：老品/黑鸭/散称
     */
    private String prdClass;

    /**
     * 是否执行：1:执行；0：未执行；
     */
    private Integer planStatus;

    /**
     *
     */
    private Date createTime;

    /**
     *
     */
    private Date modifyTime;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 最近修改人
     */
    private String modifyBy;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}