package com.wangxiaolu.promotion.utils;

import java.util.regex.Pattern;

/**
 * 人员信息校验
 */
public class UserUtils {

    private static final String ID_CARD_PATTERN = "^[1-9]\\d{5}(19|20)\\d{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2]\\d|3[0-1])|(04|06|09|11)(0[1-9]|[1-2]\\d|30)|02(0[1-9]|[1-2]\\d))\\d{3}[\\dXx]$";
    private static final String PHONE_NUMBER_PATTERN = "^1[3-9]\\d{9}$";

    /**
     * 身份证号检验
     */
    public static boolean idenCardPattern(String idCard) {
        return Pattern.matches(ID_CARD_PATTERN, idCard);
    }

    public static boolean phonePattern(String phoneNumber) {
        return phoneNumber.matches(PHONE_NUMBER_PATTERN);
    }


}
