package com.wangxiaolu.promotion.pojo.user.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @author : liqiulin
 * @date : 2024-04-08 12
 * @describe :
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class WxJsUserInfoVo {
    /**
     * js传过来的临时登录code
     */
//    @NotBlank(message = "微信登录凭证错误")
//    String jsCode;

    /**
     * 用户信息的加密文字
     */
//    String encryptedData;

    /**
     * 标识
     */
//    String iv;

    /**
     * openId
     */
    @NotBlank(message = "微信登录错误")
    String openId;


    /**
     * 头像
     */
    @NotBlank(message = "请上传头像")
    String avatarUrl;


    /**
     * 头像云存储文件id
     */
    String avatarUrlFieldId;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不可为空")
    String name;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不可为空")
    String phone;

    /**
     * 身份证号
     */
    @NotBlank(message = "身份证号不可为空")
    String idenNumber;

    /**
     * 身份证正面照
     */
    @NotBlank(message = "请上传身份证正面照")
    String idenFrontPhotoUrl;

    /**
     * 身份证正面照
     */
    @NotBlank(message = "请上传身份证正面照")
    String idenFrontPhotoFieldId;

    /**
     * 身份证反面照
     */
    @NotBlank(message = "请上传身份证反面照")
    String idenReversePhotoUrl;

    /**
     * 身份证反面照
     */
    @NotBlank(message = "请上传身份证反面照")
    String idenReversePhotoFieldId;

    /**
     * 详细地址
     */
    String address;

    /**
     * 手机验证码
     */
    @NotBlank(message = "验证码无效")
    String phoneCode;
}
