package com.wangxiaolu.promotion.controller.wechat;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.WxJsUserInfoVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import com.wangxiaolu.promotion.utils.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-03 17
 * @describe : 微信用户信息
 */
@Slf4j
@RestController
@RequestMapping("/user/wechat/core")
public class WeChatUserCoreController {

    @Autowired
    WeChatUserCoreService weChatUserCoreService;

    /**
     * 促销员注册信息
     */
    @PostMapping("/temporary/enroll")
    public boolean enrollUserInfo(@RequestBody @Validated WxJsUserInfoVo wxJsUserInfoVo) {
        // 人员信息校验
        boolean isIden = UserUtils.idenCardPattern(wxJsUserInfoVo.getIdenNumber());
        boolean isPhone = UserUtils.phonePattern(wxJsUserInfoVo.getPhone());

        if (!isIden || !isPhone) {
            throw new ParamException(RCode.ENROLL_PARAM_ERROR, null);
        }

        // todo 手机号校验 wxJsUserInfoVo.getPhoneCode()
        log.info("微信-促销员注册：{}", JSONObject.toJSONString(wxJsUserInfoVo));

        WxTemporaryInfoDto temporaryDto = new WxTemporaryInfoDto();
        BeanUtils.copyProperties(wxJsUserInfoVo, temporaryDto);
        return weChatUserCoreService.saveWxUserInfoTemporary(temporaryDto);
    }

}
